/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf;

import com.hp.hpl.jena.joseki.QueryEngineHTTP;
import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBinding;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class JosekiRDFContainer
implements IRDFContainer {
    protected String m_modelURI;
    static Logger s_logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.rdf.JosekiRDFContainer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public JosekiRDFContainer() {
        new RDFReaderFImpl().setReaderClassName("RDF/XML", "com.hp.hpl.jena.rdf.arp.JenaReader");
    }

    public void add(Statement s) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement add");
    }

    public void add(IRDFContainer c) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement add");
    }

    public void add(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        this.add(new Statement(subject, predicate, object));
    }

    public void remove(Statement pattern, Resource[] existentials) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement remove");
    }

    public int querySize(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        return this.query(query, variables, existentials).size();
    }

    public Set queryMulti(Statement[] query, Resource[] variables, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement queryMulti");
    }

    public Set query(Statement s, Resource[] existentials) throws RDFException {
        return this.query(new Statement[]{s}, existentials, existentials);
    }

    public Set queryMulti(Statement s, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement queryMulti");
    }

    public RDFNode extract(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        int nullCount = 0;
        Resource r = new Resource("urn:haystack:wildcard:x");
        if (subject == null) {
            subject = r;
            ++nullCount;
        }
        if (predicate == null) {
            predicate = r;
            ++nullCount;
        }
        if (object == null) {
            object = r;
            ++nullCount;
        }
        if (nullCount == 1) {
            RDFNode[] nodes = this.queryExtract(new Statement[]{new Statement(subject, predicate, object)}, new Resource[]{r}, new Resource[]{r});
            if (nodes != null) {
                return nodes[0];
            }
            return null;
        }
        throw new IllegalArgumentException("extract takes exactly one null argument");
    }

    public RDFNode[] queryExtract(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        Set results = this.query(query, variables, existentials);
        if (results.size() > 0) {
            return (RDFNode[])results.iterator().next();
        }
        return null;
    }

    public boolean contains(Statement s) throws RDFException {
        Resource r = new Resource("urn:haystack:wildcard:x");
        RDFNode o = s.getObject();
        Set results = this.query(new Statement(s.getSubject(), s.getPredicate(), r), new Resource[]{r});
        Iterator i = results.iterator();
        while (i.hasNext()) {
            RDFNode[] nodes = (RDFNode[])i.next();
            if (!nodes[0].equals(o)) continue;
            return true;
        }
        return false;
    }

    public Resource getStatementID(Statement s) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement getStatementID");
    }

    public Resource[] getAuthors(Statement s) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement getAuthors");
    }

    public Resource[] getAuthors(Resource id) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement getAuthor");
    }

    public Statement getStatement(Resource id) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement getStatement");
    }

    public Resource[] getAuthoredStatementIDs(Resource author) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement getAuthoredStatementIDs");
    }

    public Statement[] getAuthoredStatements(Resource author) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement getAuthoredStatements");
    }

    public int size() throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement size");
    }

    public Iterator iterator() throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement iterator");
    }

    public boolean supportsEnumeration() {
        return false;
    }

    public boolean supportsAuthoring() {
        return false;
    }

    public void replace(Resource subject, Resource predicate, RDFNode object, RDFNode newValue) throws RDFException {
        throw new UnsupportedOperationException("JosekiRDFContainer does not implement replace");
    }

    public Set query(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        HashMap<String, String> existentialMap = new HashMap<String, String>();
        int i = 0;
        while (i < existentials.length) {
            String s = existentials[i].getURI();
            if (s.startsWith("urn:haystack:wildcard:")) {
                existentialMap.put(s, "v" + s.substring("urn:haystack:wildcard:".length()));
            } else {
                existentialMap.put(s, s);
            }
            ++i;
        }
        String queryString = "SELECT ";
        boolean first = true;
        int i2 = 0;
        while (i2 < variables.length) {
            queryString = first ? String.valueOf(queryString) + "?" : String.valueOf(queryString) + ", ?";
            first = false;
            queryString = String.valueOf(queryString) + existentialMap.get(variables[i2].getURI());
            ++i2;
        }
        queryString = String.valueOf(queryString) + " WHERE ";
        first = true;
        i2 = 0;
        while (i2 < query.length) {
            if (!first) {
                queryString = String.valueOf(queryString) + ", ";
            }
            first = false;
            Statement statement = query[i2];
            Resource s = statement.getSubject();
            String s2 = (String)existentialMap.get(s.getURI());
            Resource p = statement.getPredicate();
            String p2 = (String)existentialMap.get(p.getURI());
            RDFNode o = statement.getObject();
            queryString = String.valueOf(queryString) + "( " + (s2 != null ? "?" + s2 : "<" + s.getURI() + ">") + ", " + (p2 != null ? "?" + p2 : "<" + p.getURI() + ">") + ", ";
            if (o instanceof Literal) {
                queryString = String.valueOf(queryString) + "\"" + o.getContent() + "\"";
            } else {
                String o2 = (String)existentialMap.get(o.getContent());
                queryString = String.valueOf(queryString) + (o2 != null ? "?" + o2 : "<" + ((Resource)o).getURI() + ">");
            }
            queryString = String.valueOf(queryString) + " )";
            ++i2;
        }
        s_logger.info((Object)("Query string " + queryString + " model " + this.m_modelURI));
        try {
            QueryResults results;
            Query q = new Query(queryString);
            QueryEngineHTTP qe = new QueryEngineHTTP(q, this.m_modelURI);
            QueryResults iter = results = qe.exec();
            HashSet<RDFNode[]> finalResults = new HashSet<RDFNode[]>();
            while (iter.hasNext()) {
                ResultBinding rbind = (ResultBinding)iter.next();
                RDFNode[] tuple = new RDFNode[variables.length];
                int i3 = 0;
                while (i3 < variables.length) {
                    String s = (String)existentialMap.get(variables[i3].getURI());
                    Object o = rbind.get(s);
                    if (o instanceof com.hp.hpl.jena.rdf.model.Resource) {
                        tuple[i3] = new Resource(((com.hp.hpl.jena.rdf.model.Resource)o).getURI());
                    } else if (o instanceof com.hp.hpl.jena.rdf.model.Literal) {
                        tuple[i3] = new Literal(((com.hp.hpl.jena.rdf.model.Literal)o).getString());
                    }
                    ++i3;
                }
                finalResults.add(tuple);
            }
            results.close();
            return finalResults;
        }
        catch (Exception e) {
            s_logger.error((Object)"Failed to perform Joseki query", (Throwable)e);
            throw new RDFException("Failed to perform Joseki query");
        }
    }
}

