/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.proxy.start;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.JavaByteCodeCompiler;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.ICallable;
import edu.mit.lcs.haystack.adenine.interpreter.IDereferenceable;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.adenine.query.Condition;
import edu.mit.lcs.haystack.adenine.query.ConditionSet;
import edu.mit.lcs.haystack.proxy.IProtocol;
import edu.mit.lcs.haystack.proxy.ProxyManager;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import edu.mit.lcs.haystack.security.Identity;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;

public class STARTProtocol
implements IProtocol {
    public static String NAMESPACE = "http://haystack.lcs.mit.edu/programs/start#";
    public static Resource SERVER = new Resource(String.valueOf(NAMESPACE) + "server");

    public Object connectToService(ProxyManager manager, IRDFContainer rdfc, Resource res, Identity id) throws Exception {
        RDFNode[] info = rdfc.queryExtract(new Statement[]{new Statement(res, Constants.s_wsdl_port, Utilities.generateWildcardResource(3)), new Statement(Utilities.generateWildcardResource(3), Constants.s_wsdl_binding, Utilities.generateWildcardResource(2)), new Statement(Utilities.generateWildcardResource(2), SERVER, Utilities.generateWildcardResource(1))}, Utilities.generateWildcardResourceArray(1), Utilities.generateWildcardResourceArray(4));
        if (info == null) {
            return null;
        }
        String server = info[0].getContent();
        return new STARTQueryEngine(server, rdfc);
    }

    public IRDFContainer discoverServices(ProxyManager manager, IRDFContainer source, Resource endpoint) throws Exception {
        return null;
    }

    class STARTQueryEngine
    implements IDereferenceable,
    ICallable {
        String m_server;
        IRDFContainer m_source;

        STARTQueryEngine(String server, IRDFContainer source) {
            this.m_server = server;
            this.m_source = source;
        }

        public Object getMember(Object member) throws AdenineException {
            if (Constants.s_infoint_query.equals(member)) {
                return this;
            }
            return null;
        }

        public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {
            Resource res;
            ConditionSet cs = (ConditionSet)message.getPrimaryValue();
            Condition c = cs.get(0);
            if (!c.getFunction().equals(Constants.s_query_naturalLanguage)) {
                return null;
            }
            Literal query = (Literal)c.getParameter(0);
            JavaByteCodeCompiler compiler = new JavaByteCodeCompiler(this.m_source);
            Resource pakkage = Utilities.generateUniqueResource();
            try {
                List errors = compiler.compile(pakkage, new InputStreamReader(new URL(String.valueOf(this.m_server) + "?query=" + URLEncoder.encode(query.getContent())).openStream()), null, null, null);
                if (!errors.isEmpty()) {
                    throw (Exception)errors.get(0);
                }
                res = Utilities.getResourceProperty(pakkage, AdenineConstants.main, this.m_source);
            }
            catch (Exception e) {
                throw new AdenineException("An error occurred invoking START", e);
            }
            Interpreter interpreter = new Interpreter(this.m_source);
            return interpreter.callMethod(res, new Message());
        }
    }
}

