/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.proxy.algae;

import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.LocalRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import edu.mit.lcs.haystack.server.service.IPersistent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class AlgaeRDFContainer
implements IRDFContainer,
IPersistent {
    static Logger s_logger;
    protected String m_baseURL;
    protected String m_username;
    protected String m_password;
    protected Resource m_res;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.proxy.algae.AlgaeRDFContainer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public AlgaeRDFContainer(Resource res, String baseURL, String username, String password) {
        this.m_res = res;
        this.m_baseURL = baseURL.lastIndexOf(63) != baseURL.length() - 1 ? String.valueOf(baseURL) + "?" : baseURL;
        this.m_username = username;
        this.m_password = password;
    }

    protected InputStream doQuery(String query) throws IOException {
        URL url = new URL(String.valueOf(this.m_baseURL) + "w3c_algaeQuery=" + URLEncoder.encode(query) + "&w3c_forceText=*");
        InputStream is = url.openStream();
        return is;
    }

    protected void doAdd(String data) throws IOException {
        URL url = new URL(this.m_baseURL);
        URLConnection urlConn = url.openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        String encoding = new BASE64Encoder().encode((String.valueOf(this.m_username) + ":" + this.m_password).getBytes());
        urlConn.setRequestProperty("Authorization", "Basic " + encoding);
        DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
        String content = "w3c_annotate=" + URLEncoder.encode(data);
        printout.writeBytes(content);
        printout.flush();
        printout.close();
        DataInputStream input = new DataInputStream(urlConn.getInputStream());
        input.close();
    }

    public void add(Statement s) throws RDFException {
        try {
            this.doAdd(Utilities.generateRDF(new LocalRDFContainer(new Statement[]{s})));
        }
        catch (IOException e) {
            throw new RDFException("I/O error", e);
        }
    }

    public void add(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        this.add(new Statement(subject, predicate, object));
    }

    public void add(IRDFContainer c) throws RDFException {
        try {
            this.doAdd(Utilities.generateRDF(c));
        }
        catch (IOException e) {
            throw new RDFException("I/O error", e);
        }
    }

    public void remove(Statement pattern, Resource[] existentials) throws RDFException {
    }

    protected void convertQueryNode(RDFNode node, Resource[] existentials, StringBuffer sb) {
        int i = Utilities.indexOfResource(existentials, node);
        if (i == -1) {
            if (node instanceof Resource) {
                sb.append(node.getContent());
            } else {
                sb.append(node);
            }
        } else {
            sb.append("?x");
            sb.append(i);
        }
        sb.append(' ');
    }

    public Set query(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        StringBuffer sb = new StringBuffer("(ask '(");
        existentials = Utilities.combineResourceArrays(variables, existentials);
        int i = 0;
        while (i < query.length) {
            Statement s = query[i];
            sb.append('(');
            this.convertQueryNode(s.getPredicate(), existentials, sb);
            this.convertQueryNode(s.getSubject(), existentials, sb);
            this.convertQueryNode(s.getObject(), existentials, sb);
            sb.append(')');
            ++i;
        }
        sb.append(") :collect '(");
        i = 0;
        while (i < variables.length) {
            sb.append(" ?x");
            sb.append(Utilities.indexOfResource(existentials, variables[i]));
            ++i;
        }
        sb.append("))");
        LocalRDFContainer rdfc = new LocalRDFContainer();
        try {
            Utilities.parseRDF(this.doQuery(sb.toString()), (IRDFContainer)rdfc);
        }
        catch (FileNotFoundException fnfe) {
            return new HashSet();
        }
        catch (IOException ioe) {
            throw new RDFException("I/O error", ioe);
        }
        return rdfc.query(query, variables, existentials);
    }

    public int querySize(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        return this.query(query, variables, existentials).size();
    }

    public Set queryMulti(Statement[] query, Resource[] variables, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        throw new UnsupportedOperationException();
    }

    public Set query(Statement s, Resource[] existentials) throws RDFException {
        return this.query(new Statement[]{s}, existentials, existentials);
    }

    public Set queryMulti(Statement s, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        throw new UnsupportedOperationException();
    }

    public RDFNode extract(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        Resource res;
        Statement s = new Statement(subject == null ? res : subject, predicate == null ? res : predicate, object == null ? res : object);
        RDFNode[] result = this.queryExtract(new Statement[]{s}, new Resource[]{res = Utilities.generateWildcardResource(1)}, new Resource[]{res});
        if (result == null) {
            return null;
        }
        return result[0];
    }

    public RDFNode[] queryExtract(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        Set s = this.query(query, variables, existentials);
        if (s.isEmpty()) {
            return null;
        }
        return (RDFNode[])s.iterator().next();
    }

    public boolean contains(Statement s) throws RDFException {
        StringBuffer sb = new StringBuffer("(ask '((");
        sb.append(s.getPredicate().getContent());
        sb.append(' ');
        sb.append(s.getSubject().getContent());
        sb.append(' ');
        RDFNode node = s.getObject();
        if (node instanceof Resource) {
            sb.append(node.getContent());
        } else {
            sb.append(node);
        }
        sb.append(")) :collect '())");
        LocalRDFContainer rdfc = new LocalRDFContainer();
        try {
            Utilities.parseRDF(this.doQuery(sb.toString()), (IRDFContainer)rdfc);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        catch (IOException ioe) {
            throw new RDFException("I/O error", ioe);
        }
        return rdfc.contains(s);
    }

    public Resource getStatementID(Statement s) throws RDFException {
        return null;
    }

    public Resource[] getAuthors(Statement s) throws RDFException {
        return null;
    }

    public Resource[] getAuthors(Resource id) throws RDFException {
        return null;
    }

    public Statement getStatement(Resource id) throws RDFException {
        return null;
    }

    public Resource[] getAuthoredStatementIDs(Resource author) throws RDFException {
        return null;
    }

    public Statement[] getAuthoredStatements(Resource author) throws RDFException {
        return null;
    }

    public int size() throws RDFException {
        return 0;
    }

    public Iterator iterator() throws RDFException {
        return null;
    }

    public boolean supportsEnumeration() {
        return false;
    }

    public boolean supportsAuthoring() {
        return false;
    }

    public void replace(Resource subject, Resource predicate, RDFNode object, RDFNode newValue) throws RDFException {
    }

    public Resource getServiceResource() {
        return this.m_res;
    }
}

