/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.proxy;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.ICallable;
import edu.mit.lcs.haystack.adenine.interpreter.IDereferenceable;
import edu.mit.lcs.haystack.adenine.interpreter.InvalidMemberException;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;

class SOAPProtocolAdenineHandler
implements IDereferenceable {
    Resource m_binding;
    Resource m_address;
    IRDFContainer m_source;

    SOAPProtocolAdenineHandler(Resource binding, Resource address, IRDFContainer source) {
        this.m_binding = binding;
        this.m_address = address;
        this.m_source = source;
    }

    public Object getMember(Object member) throws AdenineException {
        if (!(member instanceof Resource)) {
            throw new InvalidMemberException(member);
        }
        try {
            if (this.m_source.queryExtract(new Statement[]{new Statement(this.m_binding, Constants.s_wsdl_type, Utilities.generateWildcardResource(1)), new Statement(Utilities.generateWildcardResource(1), Constants.s_wsdl_operation, (Resource)member)}, Utilities.generateWildcardResourceArray(1), Utilities.generateWildcardResourceArray(1)) == null) {
                throw new InvalidMemberException(member);
            }
        }
        catch (RDFException e) {
            throw new InvalidMemberException(member);
        }
        return new ICallable(){
            Resource m_member;

            public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {
                RDFNode[] datum;
                try {
                    datum = SOAPProtocolAdenineHandler.this.m_source.queryExtract(new Statement[]{new Statement(this.m_member, Constants.s_dc_title, Utilities.generateWildcardResource(5)), new Statement(SOAPProtocolAdenineHandler.this.m_binding, Constants.s_wsdl_operationBinding, Utilities.generateWildcardResource(1)), new Statement(Utilities.generateWildcardResource(1), Constants.s_wsdl_bindingOperation, this.m_member), new Statement(Utilities.generateWildcardResource(1), Constants.s_wsdl_inputBinding, Utilities.generateWildcardResource(2)), new Statement(Utilities.generateWildcardResource(2), Constants.s_soap_encodingStyle, Utilities.generateWildcardResource(3)), new Statement(Utilities.generateWildcardResource(2), Constants.s_soap_namespace_, Utilities.generateWildcardResource(4))}, Utilities.generateWildcardResourceArray(5), Utilities.generateWildcardResourceArray(5));
                }
                catch (RDFException e) {
                    datum = null;
                }
                if (datum == null) {
                    throw new InvalidMemberException(this.m_member);
                }
                try {
                    Service service = new Service();
                    Call call = (Call)service.createCall();
                    call.setTargetEndpointAddress(new URL(SOAPProtocolAdenineHandler.this.m_address.getURI()));
                    call.setOperationName(new QName(datum[3].getContent(), datum[4].getContent()));
                    return new Message(call.invoke(message.getOrderedValues()));
                }
                catch (Exception e) {
                    throw new AdenineException("SOAP error", e);
                }
            }

            ICallable init(Resource member2) {
                this.m_member = member2;
                return this;
            }
        }.init((Resource)member);
    }
}

