/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.proxy;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.ReaderInputStream;
import edu.mit.lcs.haystack.proxy.DefaultMarshaller;
import edu.mit.lcs.haystack.proxy.IProtocol;
import edu.mit.lcs.haystack.proxy.IServiceAccessor;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import edu.mit.lcs.haystack.security.Identity;
import edu.mit.lcs.haystack.security.IdentityManager;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.catalina.util.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProxyManager
implements IServiceAccessor {
    protected IRDFContainer m_root;
    protected IdentityManager m_identityManager;

    public ProxyManager(IRDFContainer rdfc, IdentityManager im) {
        this.m_root = rdfc;
        this.m_identityManager = im;
    }

    public IRDFContainer getRootRDFContainer() {
        return this.m_root;
    }

    public void setRootRDFContainer(IRDFContainer root) {
        this.m_root = root;
    }

    public Resource getResource() {
        return null;
    }

    public String encode(Object o, Class c) {
        String className = c.getName();
        int dims = className.lastIndexOf(91) + 1;
        className = className.substring(dims);
        if (dims == 0) {
            className = "L" + className + ";";
        }
        DefaultMarshaller m = new DefaultMarshaller();
        if (dims > 0) {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("<soap-enc:Array xmlns:soap-enc=\"");
                sb.append("http://schemas.xmlsoap.org/soap/encoding/");
                sb.append("\">");
                int i = 0;
                while (i < ((Object[])o).length) {
                    sb.append("<soap-enc:item>");
                    sb.append(m.encode(((Object[])o)[i]));
                    sb.append("</soap-enc:item>");
                    ++i;
                }
                sb.append("</soap-enc:Array>");
                return sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return m.encode(o);
    }

    public Object decode(String s, Class c) {
        String className = c.getName();
        int dims = className.lastIndexOf(91) + 1;
        String baseClassName = className = className.substring(dims);
        if (dims == 0) {
            className = "L" + className + ";";
        } else {
            baseClassName = baseClassName.substring(1, baseClassName.length() - 1);
        }
        DefaultMarshaller m = new DefaultMarshaller();
        if (dims > 0) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new ReaderInputStream(s));
                NodeList nl = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/encoding/", "item");
                Object[] o = (Object[])Array.newInstance(Class.forName(baseClassName), nl.getLength());
                int i = 0;
                while (i < nl.getLength()) {
                    Node n = nl.item(i);
                    NodeList nl2 = n.getChildNodes();
                    StringWriter sw = new StringWriter();
                    DOMWriter writer = new DOMWriter((Writer)sw, true);
                    int j = 0;
                    while (j < nl2.getLength()) {
                        writer.print(nl2.item(j));
                        ++j;
                    }
                    o[i] = m.decode(sw.toString());
                    ++i;
                }
                return o;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return m.decode(s);
    }

    public Object connectToService(Resource res, Identity id) throws Exception {
        Set protocols = this.m_root.query(new Statement[]{new Statement(res, Constants.s_wsdl_port, Utilities.generateWildcardResource(4)), new Statement(Utilities.generateWildcardResource(4), Constants.s_wsdl_binding, Utilities.generateWildcardResource(2)), new Statement(Utilities.generateWildcardResource(2), Constants.s_rdf_type, Utilities.generateWildcardResource(3)), new Statement(Utilities.generateWildcardResource(1), Constants.s_config_bindingDomain, Utilities.generateWildcardResource(3))}, new Resource[]{Utilities.generateWildcardResource(1), Utilities.generateWildcardResource(3)}, Utilities.generateWildcardResourceArray(4));
        Iterator i = protocols.iterator();
        while (i.hasNext()) {
            Resource protocol = (Resource)((RDFNode[])i.next())[0];
            Class c = Utilities.loadClass(protocol, this.m_root);
            IProtocol p = (IProtocol)c.newInstance();
            Object o = p.connectToService(this, this.m_root, res, id);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public IRDFContainer discoverServices(Resource protocol, Resource endpoint) throws Exception {
        Class c = Utilities.loadClass(protocol, this.m_root);
        IProtocol p = (IProtocol)c.newInstance();
        return p.discoverServices(this, this.m_root, endpoint);
    }

    public boolean isShuttingDown() {
        return false;
    }

    public IdentityManager getIdentityManager() {
        return this.m_identityManager;
    }
}

