/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.tokenizer;

import edu.mit.lcs.haystack.adenine.tokenizer.CharIterator;
import edu.mit.lcs.haystack.adenine.tokenizer.CommentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ErrorToken;
import edu.mit.lcs.haystack.adenine.tokenizer.FloatToken;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.IScannerVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.ITokenIterator;
import edu.mit.lcs.haystack.adenine.tokenizer.IndentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.IntegerToken;
import edu.mit.lcs.haystack.adenine.tokenizer.LiteralToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.NewLineToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Span;
import edu.mit.lcs.haystack.adenine.tokenizer.StringToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;
import edu.mit.lcs.haystack.adenine.tokenizer.WhitespaceToken;
import java.io.Reader;
import java.util.LinkedList;

public class Tokenizer
implements ITokenIterator {
    LinkedList m_tokens = new LinkedList();
    int m_line;
    int m_column;
    boolean m_eof;
    int m_tabSize;
    CharIterator m_charIterator;
    IScannerVisitor m_scannerVisitor;
    protected static String s_fullResourceExcepts = ">\r\n\t";
    protected static String s_genericTokenExcepts = "<>(){}[].,;'\"`@$%? \r\n\t\u0000";

    public Tokenizer(Reader input, IScannerVisitor sVisitor, int tabSize, int startLine, int startColumn, int startOffset) {
        this.m_charIterator = new CharIterator(input, startOffset);
        this.m_scannerVisitor = sVisitor;
        this.m_tabSize = tabSize;
        this.m_line = startLine;
        this.m_column = startColumn;
    }

    public Tokenizer(Reader input, IScannerVisitor sVisitor, int startLine, int startColumn, int startOffset) {
        this(input, sVisitor, 4, startLine, startColumn, startOffset);
    }

    public Tokenizer(Reader input, IScannerVisitor sVisitor) {
        this(input, sVisitor, 4, 0, 0, 0);
    }

    public final Token getToken() {
        return this.getToken(0);
    }

    public final Token getToken(int ahead) {
        this.fetchSeveralTokens(ahead + 1);
        if (this.m_tokens.size() > ahead) {
            return (Token)this.m_tokens.get(ahead);
        }
        return null;
    }

    public final Location getLocation() {
        this.fetchSeveralTokens(1);
        if (this.m_tokens.size() > 0) {
            return ((Token)this.m_tokens.get(0)).getSpan().getStart();
        }
        return new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
    }

    public final void swallow() {
        this.swallow(1);
    }

    public final void swallow(int count) {
        this.fetchSeveralTokens(count);
        while (count > 0 && this.m_tokens.size() > 0) {
            Token token = (Token)this.m_tokens.remove(0);
            --count;
            if (this.m_scannerVisitor == null) continue;
            this.m_scannerVisitor.onToken(token);
        }
    }

    final void fetchSeveralTokens(int count) {
        while (!this.m_eof && this.m_tokens.size() < count) {
            this.parseNextToken();
        }
    }

    final void parseNextToken() {
        char c = this.m_charIterator.getChar();
        if (c == '\u0000') {
            this.m_eof = true;
            return;
        }
        if (c == '\r' || c == '\n') {
            this.parseNewLine(c);
        } else if (c == ' ' || c == '\t') {
            this.parseWhitespaceOrIndent(c);
        } else if (c == '#') {
            this.parseComment(c);
        } else if (c == '<') {
            this.parseFullResource(c);
        } else if (c == '\"') {
            this.parseLiteral(c);
        } else if (c == '\'') {
            this.parseString(c);
        } else if (c == '?') {
            this.parseWildcardResource(c);
        } else if (c == ':' || Character.isLetter(c)) {
            this.parseGenericTokenOrPrefixedResource(c);
        } else if (Character.isDigit(c) || c == '-' || c == '+') {
            this.parseNumber(c);
        } else {
            Location start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
            this.m_charIterator.swallow();
            Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
            ++this.m_column;
            this.addToken(new SymbolToken(new Span(start, end), Character.toString(c)));
        }
    }

    final void addToken(Token t) {
        this.m_tokens.add(t);
    }

    final void parseNewLine(char c) {
        Location start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        this.swallowOneColumn(c);
        if (c == '\r' && !this.m_charIterator.isEOF() && (c = this.m_charIterator.getChar()) == '\n') {
            this.swallowOneColumn(c);
        }
        Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        this.newLine();
        this.addToken(new NewLineToken(new Span(start, end)));
    }

    final void parseWhitespaceOrIndent(char c) {
        boolean newLine;
        Location start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        boolean bl = newLine = start.getColumn() == 0;
        while (true) {
            if (c == ' ' || c == '\t') {
                this.swallowOneColumn(c);
                if (this.m_charIterator.isEOF()) break;
                c = this.m_charIterator.getChar();
                continue;
            }
            if (c != '#') break;
            this.addToken(new WhitespaceToken(new Span(start, new Location(this.m_line, this.m_column, this.m_charIterator.getOffset()))));
            this.parseComment(c);
            c = this.m_charIterator.getChar();
            start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        }
        Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        if (newLine && c != '#' && c != '\r' && c != '\n' && c != '\u0000') {
            this.addToken(new IndentToken(new Span(start, end)));
        } else {
            this.addToken(new WhitespaceToken(new Span(start, end)));
        }
    }

    final void parseComment(char c) {
        if (this.m_charIterator.getChar(1) == '[') {
            this.parseMultilineComment(c);
        } else {
            this.parseSinglelineComment(c);
        }
    }

    final void parseSinglelineComment(char c) {
        Location start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        while (c != '\r' && c != '\n') {
            this.swallowOneColumn(c);
            if (this.m_charIterator.isEOF()) break;
            c = this.m_charIterator.getChar();
        }
        Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        this.addToken(new CommentToken(new Span(start, end), false));
    }

    final void parseMultilineComment(char c) {
        Location start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        this.swallowOneColumn(c);
        this.swallowOneColumn(c);
        int nestedLevel = 1;
        int openCount = 1;
        int closeCount = 0;
        while (!this.m_charIterator.isEOF()) {
            c = this.m_charIterator.getChar();
            this.swallowOneColumn(c);
            if (c == '\r') {
                if (!this.m_charIterator.isEOF() && (c = this.m_charIterator.getChar()) == '\n') {
                    this.swallowOneColumn(c);
                }
                this.newLine();
                continue;
            }
            if (c == '\n') {
                this.newLine();
                continue;
            }
            if (c == '#') {
                if (this.m_charIterator.isEOF()) continue;
                c = this.m_charIterator.getChar();
                if (c == '[') {
                    this.swallowOneColumn(c);
                    ++nestedLevel;
                    ++openCount;
                    continue;
                }
                if (c != ']') continue;
                this.swallowOneColumn(c);
                ++closeCount;
                if (--nestedLevel != 0) continue;
                break;
            }
            if (c != ']' || this.m_charIterator.isEOF() || (c = this.m_charIterator.getChar()) != '#') continue;
            this.swallowOneColumn(c);
            ++closeCount;
            if (--nestedLevel == 0) break;
        }
        Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        if (nestedLevel == 0) {
            this.addToken(new CommentToken(new Span(start, end), true));
        } else {
            this.addToken(new ErrorToken(new Span(start, end), "Multiline comment opened " + openCount + " time(s) but closed only " + closeCount + " time(s)"));
        }
    }

    final void parseFullResource(char c) {
        Location start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        StringBuffer sb = new StringBuffer();
        this.swallowOneColumn(c);
        while (!this.m_charIterator.isEOF()) {
            c = this.m_charIterator.getChar();
            if (s_fullResourceExcepts.indexOf(c) >= 0) break;
            sb.append(c);
            this.swallowOneColumn(c);
        }
        if (c == '>') {
            this.swallowOneColumn(c);
            Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
            this.addToken(new ResourceToken(new Span(start, end), null, sb.toString()));
        } else {
            Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
            this.addToken(new ErrorToken(new Span(start, end), "Full resource URI missing closing angle bracket"));
        }
    }

    final void parseLiteral(char c) {
        Location start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        StringBuffer sb = new StringBuffer();
        boolean tripleQuote = false;
        if (this.m_charIterator.getChar(1) == '\"' && this.m_charIterator.getChar(2) == '\"') {
            this.swallowOneColumn(c);
            this.swallowOneColumn(c);
            this.swallowOneColumn(c);
            while (!this.m_charIterator.isEOF()) {
                c = this.m_charIterator.getChar();
                if (c == '\"' && this.m_charIterator.getChar(1) == '\"' && this.m_charIterator.getChar(2) == '\"') {
                    this.swallowOneColumn(c);
                    this.swallowOneColumn(c);
                    this.swallowOneColumn(c);
                    break;
                }
                switch (c) {
                    case '\r': {
                        char c1 = this.m_charIterator.getChar(1);
                        if (c1 == '\n') {
                            this.swallowOneColumn(c);
                            c = c1;
                        }
                    }
                    case '\n': {
                        sb.append('\n');
                        this.newLine();
                        break;
                    }
                    default: {
                        if (c == '\\' && this.m_charIterator.getChar(1) != '\u0000') {
                            this.swallowOneColumn(c);
                            char c2 = this.m_charIterator.getChar();
                            switch (c2) {
                                case 't': {
                                    sb.append('\t');
                                    break;
                                }
                                case 'r': {
                                    sb.append('\r');
                                    break;
                                }
                                case 'n': {
                                    sb.append('\n');
                                    break;
                                }
                                case 'b': {
                                    sb.append('\b');
                                    break;
                                }
                                case '\"': {
                                    sb.append('\"');
                                    break;
                                }
                                case '\'': {
                                    sb.append('\'');
                                    break;
                                }
                                case '\r': {
                                    char c3 = this.m_charIterator.getChar(1);
                                    if (c3 == '\n') {
                                        this.swallowOneColumn(c2);
                                        c2 = c3;
                                    }
                                }
                                case '\n': {
                                    this.newLine();
                                    sb.append(c);
                                    break;
                                }
                                default: {
                                    sb.append(c);
                                    sb.append(c2);
                                }
                            }
                            c = c2;
                            break;
                        }
                        sb.append(c);
                    }
                }
                this.swallowOneColumn(c);
            }
            if (c == '\"') {
                Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
                this.addToken(new LiteralToken(new Span(start, end), sb.toString()));
            } else {
                Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
                this.addToken(new ErrorToken(new Span(start, end), "Literal missing closing quote mark"));
            }
        } else {
            this.swallowOneColumn(c);
            while (!this.m_charIterator.isEOF()) {
                c = this.m_charIterator.getChar();
                if (c == '\r' || c == '\n' || c == '\"') break;
                if (c == '\\' && this.m_charIterator.getChar(1) != '\u0000') {
                    this.swallowOneColumn(c);
                    char c2 = this.m_charIterator.getChar();
                    switch (c2) {
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'b': {
                            sb.append('\b');
                            break;
                        }
                        case '\"': {
                            sb.append('\"');
                            break;
                        }
                        case '\'': {
                            sb.append('\'');
                            break;
                        }
                        case '\r': {
                            char c3 = this.m_charIterator.getChar(1);
                            if (c3 == '\n') {
                                this.swallowOneColumn(c2);
                                c2 = c3;
                            }
                        }
                        case '\n': {
                            this.newLine();
                            break;
                        }
                        default: {
                            sb.append(c);
                            sb.append(c2);
                        }
                    }
                    c = c2;
                } else {
                    sb.append(c);
                }
                this.swallowOneColumn(c);
            }
            if (c == '\"') {
                this.swallowOneColumn(c);
                Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
                this.addToken(new LiteralToken(new Span(start, end), sb.toString()));
            } else {
                Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
                this.addToken(new ErrorToken(new Span(start, end), "Literal missing closing quote mark"));
            }
        }
    }

    final void parseString(char c) {
        Location start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        StringBuffer sb = new StringBuffer();
        this.swallowOneColumn(c);
        while (!this.m_charIterator.isEOF()) {
            c = this.m_charIterator.getChar();
            if (c == '\r' || c == '\n' || c == '\'') break;
            if (c == '\\' && this.m_charIterator.getChar(1) != '\u0000') {
                this.swallowOneColumn(c);
                char c2 = this.m_charIterator.getChar();
                switch (c2) {
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\r': {
                        char c3 = this.m_charIterator.getChar(1);
                        if (c3 == '\n') {
                            this.swallowOneColumn(c2);
                            c2 = c3;
                        }
                    }
                    case '\n': {
                        this.newLine();
                        break;
                    }
                    default: {
                        sb.append(c);
                        sb.append(c2);
                    }
                }
                c = c2;
            } else {
                sb.append(c);
            }
            this.swallowOneColumn(c);
        }
        if (c == '\'') {
            this.swallowOneColumn(c);
            Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
            this.addToken(new StringToken(new Span(start, end), sb.toString()));
        } else {
            Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
            this.addToken(new ErrorToken(new Span(start, end), "String missing closing single-quote mark"));
        }
    }

    final void parseGenericTokenOrPrefixedResource(char c) {
        Location start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        StringBuffer sb = new StringBuffer();
        while (s_genericTokenExcepts.indexOf(c) < 0) {
            this.swallowOneColumn(c);
            if (c == ':') {
                this.parsePrefixedResource(start, sb.toString());
                return;
            }
            sb.append(c);
            if (this.m_charIterator.isEOF()) break;
            c = this.m_charIterator.getChar();
        }
        Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        this.addToken(new GenericToken(new Span(start, end), sb.toString()));
    }

    final void parsePrefixedResource(Location start, String prefix) {
        StringBuffer sb = new StringBuffer();
        char c = this.m_charIterator.getChar();
        while (s_genericTokenExcepts.indexOf(c) < 0) {
            this.swallowOneColumn(c);
            sb.append(c);
            if (this.m_charIterator.isEOF()) break;
            c = this.m_charIterator.getChar();
        }
        Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        Span span = new Span(start, end);
        this.addToken(new ResourceToken(span, prefix, sb.toString()));
    }

    final void parseWildcardResource(char c) {
        Location start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        StringBuffer sb = new StringBuffer();
        this.swallowOneColumn(c);
        while (!this.m_charIterator.isEOF()) {
            c = this.m_charIterator.getChar();
            if (s_genericTokenExcepts.indexOf(c) >= 0) break;
            this.swallowOneColumn(c);
            sb.append(c);
        }
        Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        Span span = new Span(start, end);
        if (sb.length() > 0) {
            this.addToken(new ResourceToken(span, null, "urn:haystack:wildcard:" + sb.toString()));
        } else {
            this.addToken(new ErrorToken(span, "Wildcard URI incomplete"));
        }
    }

    final void parseNumber(char c) {
        int sign;
        Location start = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        StringBuffer sb = new StringBuffer();
        int digitCount = 0;
        boolean isFloat = false;
        long decimalRatio = 1L;
        long value = 0L;
        if (c == '+') {
            sign = 1;
            this.swallowOneColumn(c);
            sb.append(c);
        } else if (c == '-') {
            sign = -1;
            this.swallowOneColumn(c);
            sb.append(c);
        } else {
            sign = 1;
        }
        while (!this.m_charIterator.isEOF()) {
            c = this.m_charIterator.getChar();
            if (Character.isDigit(c)) {
                value = value * 10L + (long)Character.getNumericValue(c);
                this.swallowOneColumn(c);
                sb.append(c);
                ++digitCount;
                decimalRatio *= 10L;
                continue;
            }
            if (c == '.') {
                this.swallowOneColumn(c);
                isFloat = true;
                continue;
            }
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n' || digitCount != 0) break;
            Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
            Span span = new Span(start, end);
            this.addToken(new SymbolToken(span, sign == 1 ? "+" : "-"));
            return;
        }
        Location end = new Location(this.m_line, this.m_column, this.m_charIterator.getOffset());
        Span span = new Span(start, end);
        if (digitCount > 0) {
            if (isFloat) {
                this.addToken(new FloatToken(span, sb.toString(), (float)value * (float)sign / (float)decimalRatio));
            } else {
                this.addToken(new IntegerToken(span, sb.toString(), (int)(value * (long)sign)));
            }
        } else {
            this.addToken(new ErrorToken(span, "Malformed integer or float"));
        }
    }

    final void swallowOneColumn(char c) {
        this.m_charIterator.swallow();
        this.m_column = c == '\t' ? (this.m_column / this.m_tabSize + 1) * this.m_tabSize : ++this.m_column;
    }

    final void newLine() {
        ++this.m_line;
        this.m_column = 0;
    }
}

