/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.parser2.constructs;

import edu.mit.lcs.haystack.adenine.constructs.IBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IAttributeVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ICodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IConstructParser;
import edu.mit.lcs.haystack.adenine.parser2.IConstructVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullAttributeVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullCodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ParserUtilities;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ITokenIterator;
import edu.mit.lcs.haystack.adenine.tokenizer.IndentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;

public class BlockParser
implements IConstructParser {
    public Location parseConstruct(ITokenIterator tIterator, IConstructVisitor constructVisitor, IndentToken indentToken) {
        IBlockVisitor visitor = constructVisitor instanceof IBlockVisitor ? (IBlockVisitor)constructVisitor : new IBlockVisitor(){
            IConstructVisitor m_constructVisitor;

            public IAttributeVisitor onAttribute(SymbolToken semicolonT) {
                return new NullAttributeVisitor(this.m_constructVisitor);
            }

            public void onBlock(GenericToken blockKeyword, GenericToken identifier) {
            }

            public ICodeBlockVisitor onBody(Location location) {
                return new NullCodeBlockVisitor(this.m_constructVisitor);
            }

            public void start(Location startLocation) {
                this.m_constructVisitor.start(startLocation);
            }

            public void end(Location endLocation) {
                this.m_constructVisitor.end(endLocation);
            }

            public void onException(Exception exception) {
                this.m_constructVisitor.onException(exception);
            }

            public IBlockVisitor init(IConstructVisitor constructVisitor) {
                this.m_constructVisitor = constructVisitor;
                return this;
            }
        }.init(constructVisitor);
        visitor.start(tIterator.getLocation());
        Token token = tIterator.getToken();
        Location endLocation = null;
        if (token instanceof GenericToken && ((GenericToken)token).getContent().equals("block")) {
            GenericToken blockKeyword = (GenericToken)token;
            GenericToken identifier = null;
            tIterator.swallow();
            ParserUtilities.skipWhitespacesAndComments(tIterator);
            token = tIterator.getToken();
            if (ParserUtilities.isPotentialIdentifier(token)) {
                identifier = ParserUtilities.parseCompoundGenericToken(tIterator, token, true);
            }
            visitor.onBlock(blockKeyword, identifier);
            endLocation = tIterator.getLocation();
            token = ParserUtilities.skipToNextLine(tIterator);
            if (token != null) {
                visitor.onException(new SyntaxException("Unexpected code after block keyword and optional identifier", token.getSpan()));
            }
            ParserUtilities.skipWhitespacesCommentsAndNewLines(tIterator);
            token = tIterator.getToken();
            if (token instanceof IndentToken && indentToken.isOuterLevelOf((IndentToken)token)) {
                endLocation = ParserUtilities.parseCodeBlock(tIterator, visitor.onBody(tIterator.getLocation()), (IndentToken)token);
            }
        } else {
            visitor.onException(new SyntaxException("Expected block keyword", tIterator.getLocation()));
            ParserUtilities.skipToNextLine(tIterator);
        }
        if (endLocation == null) {
            endLocation = tIterator.getLocation();
        }
        visitor.end(endLocation);
        return endLocation;
    }
}

