/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.parser2;

import edu.mit.lcs.haystack.adenine.constructs.IMethodVisitor;
import edu.mit.lcs.haystack.adenine.parser2.BlockFilterTokenIterator;
import edu.mit.lcs.haystack.adenine.parser2.IAnonymousModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IApplyVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IAskModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IAttributeVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ICodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IConstructVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IListVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ISubExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.Parser;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.tokenizer.CommentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.FloatToken;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ITokenIterator;
import edu.mit.lcs.haystack.adenine.tokenizer.IndentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.IntegerToken;
import edu.mit.lcs.haystack.adenine.tokenizer.LiteralToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.NewLineToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Span;
import edu.mit.lcs.haystack.adenine.tokenizer.StringToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;
import edu.mit.lcs.haystack.adenine.tokenizer.WhitespaceToken;

public final class ParserUtilities {
    public static void skipAllWhitespaces(ITokenIterator tIterator) {
        Token token;
        while ((token = tIterator.getToken()) instanceof WhitespaceToken || token instanceof NewLineToken || token instanceof IndentToken || token instanceof CommentToken) {
            tIterator.swallow();
        }
    }

    public static Token skipToNextLine(ITokenIterator tIterator) {
        Token unwantedToken = null;
        while (true) {
            Token token = tIterator.getToken();
            tIterator.swallow();
            if (token == null || token instanceof NewLineToken) break;
            if (unwantedToken != null || token instanceof WhitespaceToken || token instanceof CommentToken) continue;
            unwantedToken = token;
        }
        return unwantedToken;
    }

    public static void skipWhitespacesAndComments(ITokenIterator tIterator) {
        Token token;
        while ((token = tIterator.getToken()) instanceof WhitespaceToken || token instanceof CommentToken) {
            tIterator.swallow();
        }
    }

    public static void skipWhitespacesCommentsAndNewLines(ITokenIterator tIterator) {
        Token token;
        while ((token = tIterator.getToken()) instanceof WhitespaceToken || token instanceof NewLineToken || token instanceof CommentToken) {
            tIterator.swallow();
        }
    }

    public static GenericToken parseCompoundGenericToken(ITokenIterator tIterator, Token token, boolean swallow) {
        SymbolToken symbolToken;
        String s2;
        Location start = token.getSpan().getStart();
        Location end = null;
        String s = "";
        int i = 0;
        do {
            s = String.valueOf(s) + (token instanceof SymbolToken ? ((SymbolToken)token).getSymbol() : ((GenericToken)token).getContent());
            end = token.getSpan().getEnd();
            if (swallow) {
                tIterator.swallow();
                continue;
            }
            ++i;
        } while (!((token = tIterator.getToken(i)) instanceof SymbolToken ? Parser.s_compoundGenericTokenExcepts.indexOf((s2 = (symbolToken = (SymbolToken)token).getSymbol()).charAt(0)) >= 0 : !(token instanceof GenericToken)));
        return new GenericToken(new Span(start, end), s);
    }

    public static GenericToken parseCompoundGenericToken(ITokenIterator tIterator, Token token) {
        return ParserUtilities.parseCompoundGenericToken(tIterator, token, true);
    }

    public static void parseSeveralAttributesAtLinesEnd(ITokenIterator tIterator, IConstructVisitor visitor) {
        SymbolToken symbolToken;
        String s;
        Token token = null;
        do {
            ParserUtilities.skipWhitespacesAndComments(tIterator);
        } while ((token = tIterator.getToken()) instanceof SymbolToken && (s = (symbolToken = (SymbolToken)token).getSymbol()).equals(";") && Parser.parseAttribute(tIterator, visitor.onAttribute(symbolToken), symbolToken));
        if (token != null) {
            if (token instanceof NewLineToken) {
                tIterator.swallow();
            } else {
                visitor.onException(new SyntaxException("Expected end of line", tIterator.getLocation()));
                ParserUtilities.skipToNextLine(tIterator);
            }
        }
    }

    protected static boolean parseAttributeAtLinesEnd(ITokenIterator tIterator, IAttributeVisitor visitor, SymbolToken semicolonToken) {
        visitor.start(tIterator.getLocation());
        tIterator.swallow();
        ParserUtilities.skipWhitespacesAndComments(tIterator);
        Token token = tIterator.getToken();
        boolean r = ParserUtilities.parseExpression(tIterator, visitor.onPredicate(token.getSpan().getStart()), false);
        if (r) {
            ParserUtilities.skipWhitespacesAndComments(tIterator);
            r = ParserUtilities.parseExpression(tIterator, visitor.onObject(token.getSpan().getStart()), false);
        }
        visitor.end(tIterator.getLocation());
        return r;
    }

    public static boolean isSemicolon(Token token) {
        return token instanceof SymbolToken && ((SymbolToken)token).getSymbol().equals(";");
    }

    public static boolean isPotentialIdentifier(Token token) {
        return token instanceof SymbolToken || token instanceof GenericToken;
    }

    public static Location parseMethod(ITokenIterator tIterator, IMethodVisitor visitor, GenericToken methodToken, boolean anonymousMethod) {
        SymbolToken semicolonToken;
        visitor.start(methodToken.getSpan().getStart());
        tIterator.swallow();
        ParserUtilities.skipWhitespacesAndComments(tIterator);
        ParserUtilities.parseExpression(tIterator, visitor.onMethod(methodToken), false);
        Location endLocation = null;
        ParserUtilities.skipWhitespacesAndComments(tIterator);
        Token token = tIterator.getToken();
        while (!ParserUtilities.isSemicolon(token) && ParserUtilities.isPotentialIdentifier(token)) {
            visitor.onParameter(ParserUtilities.parseCompoundGenericToken(tIterator, token, true));
            ParserUtilities.skipWhitespacesAndComments(tIterator);
            token = tIterator.getToken();
        }
        while (token instanceof ResourceToken) {
            SymbolToken equalToken;
            ResourceToken name = (ResourceToken)token;
            tIterator.swallow();
            ParserUtilities.skipWhitespacesAndComments(tIterator);
            token = tIterator.getToken();
            if (token instanceof SymbolToken && (equalToken = (SymbolToken)token).getSymbol().equals("=")) {
                tIterator.swallow();
                ParserUtilities.skipWhitespacesAndComments(tIterator);
                token = tIterator.getToken();
                if (ParserUtilities.isPotentialIdentifier(token)) {
                    visitor.onNamedParameter(name, equalToken, ParserUtilities.parseCompoundGenericToken(tIterator, token, true));
                    ParserUtilities.skipWhitespacesAndComments(tIterator);
                    token = tIterator.getToken();
                    continue;
                }
            }
            visitor.onException(new SyntaxException("Named parameters are of form: [name as URI] = [formal parameter variable]", tIterator.getLocation()));
            break;
        }
        ParserUtilities.skipWhitespacesCommentsAndNewLines(tIterator);
        token = tIterator.getToken();
        while (token instanceof SymbolToken && (semicolonToken = (SymbolToken)token).getSymbol().equals(";")) {
            Parser.parseAttribute(tIterator, visitor.onAttribute(semicolonToken), semicolonToken);
            ParserUtilities.skipWhitespacesCommentsAndNewLines(tIterator);
            token = tIterator.getToken();
        }
        if (token != null && token.getSpan().getStart().getColumn() > 0) {
            visitor.onException(new SyntaxException("Unexpected token of type " + token.getType(), token.getSpan()));
            ParserUtilities.skipToNextLine(tIterator);
            token = tIterator.getToken();
        }
        if (token instanceof IndentToken) {
            endLocation = ParserUtilities.parseCodeBlock(tIterator, visitor.onBlock(), (IndentToken)token);
            token = tIterator.getToken();
        }
        if (endLocation == null) {
            endLocation = tIterator.getLocation();
        }
        visitor.end(endLocation);
        return endLocation;
    }

    public static boolean parseExpression(ITokenIterator tIterator, IExpressionVisitor visitor, boolean allowEmptyExpression) {
        visitor.start(tIterator.getLocation());
        boolean processed = false;
        boolean swallow = true;
        Token token = tIterator.getToken();
        if (token instanceof IntegerToken) {
            visitor.onInteger((IntegerToken)token);
            processed = true;
        } else if (token instanceof FloatToken) {
            visitor.onFloat((FloatToken)token);
            processed = true;
        } else if (token instanceof StringToken) {
            visitor.onString((StringToken)token);
            processed = true;
        } else if (token instanceof LiteralToken) {
            visitor.onLiteral((LiteralToken)token);
            processed = true;
        } else if (token instanceof SymbolToken) {
            SymbolToken symbolToken = (SymbolToken)token;
            String s = symbolToken.getSymbol();
            swallow = false;
            processed = true;
            Location l = token.getSpan().getStart();
            if (s.equals("@")) {
                ParserUtilities.parseList(tIterator, visitor.onList(l), symbolToken);
            } else if (s.equals("{")) {
                ParserUtilities.parseModel(tIterator, visitor.onModel(l), symbolToken);
            } else if (s.equals("$")) {
                ParserUtilities.parseAnonymousModel(tIterator, visitor.onAnonymousModel(l), symbolToken);
            } else if (s.equals("%")) {
                ParserUtilities.parseAskModel(tIterator, visitor.onAskModel(l), symbolToken);
            } else if (s.equals("(")) {
                ParserUtilities.parseApply(tIterator, visitor.onApply(l), symbolToken);
            } else {
                processed = false;
            }
        }
        if (processed) {
            if (swallow) {
                tIterator.swallow();
            }
        } else if (token != null) {
            processed = ParserUtilities.parseSubExpression(tIterator, visitor.onSubExpression(token.getSpan().getStart()), allowEmptyExpression);
        }
        if (processed) {
            while (true) {
                boolean foundBracket = false;
                boolean foundPeriod = false;
                int i = 0;
                while ((token = tIterator.getToken(i)) instanceof WhitespaceToken || token instanceof CommentToken) {
                    ++i;
                }
                if (token instanceof SymbolToken) {
                    String s = ((SymbolToken)token).getSymbol();
                    if (s.equals(".")) {
                        foundPeriod = true;
                    } else if (s.equals("[")) {
                        foundBracket = true;
                    }
                }
                if (foundBracket) {
                    tIterator.swallow(i + 1);
                    ParserUtilities.skipWhitespacesAndComments(tIterator);
                    processed = ParserUtilities.parseExpression(tIterator, visitor.onLeftBracket((SymbolToken)token), false);
                    if (!processed) continue;
                    ParserUtilities.skipWhitespacesAndComments(tIterator);
                    token = tIterator.getToken();
                    if (token instanceof SymbolToken && ((SymbolToken)token).getSymbol().equals("]")) {
                        visitor.onRightBracket((SymbolToken)token);
                        tIterator.swallow();
                        continue;
                    }
                    visitor.onException(new SyntaxException("Expected ]", tIterator.getLocation()));
                    processed = false;
                    continue;
                }
                if (foundPeriod) {
                    tIterator.swallow(i + 1);
                    ParserUtilities.skipWhitespacesAndComments(tIterator);
                    processed = ParserUtilities.parseSubExpression(tIterator, visitor.onDereference((SymbolToken)token), false);
                    continue;
                }
                break;
            }
        } else if (!allowEmptyExpression) {
            visitor.onException(new SyntaxException("Empty expression not allowed here", tIterator.getLocation()));
        }
        visitor.end(tIterator.getLocation());
        return processed;
    }

    /*
     * Unable to fully structure code
     */
    public static void parseApply(ITokenIterator tIterator, IApplyVisitor visitor, SymbolToken leftParenthesisToken) {
        block27: {
            visitor.start(tIterator.getLocation());
            if (leftParenthesisToken != null) {
                visitor.onLeftParenthesis(leftParenthesisToken);
                tIterator.swallow();
                ParserUtilities.skipAllWhitespaces(tIterator);
            }
            done = false;
            if (!ParserUtilities.parseExpression(tIterator, visitor.onCallable(tIterator.getLocation()), false)) break block27;
            do {
                if (leftParenthesisToken == null) {
                    ParserUtilities.skipWhitespacesAndComments(tIterator);
                } else {
                    ParserUtilities.skipAllWhitespaces(tIterator);
                }
                token = tIterator.getToken();
                if (token instanceof ResourceToken) {
                    i = 1;
                    foundNamedParameters = false;
                    while ((token2 = tIterator.getToken(i)) instanceof WhitespaceToken || token2 instanceof CommentToken || leftParenthesisToken != null && (token2 instanceof NewLineToken || token2 instanceof IndentToken)) {
                        ++i;
                    }
                    if (token2 instanceof SymbolToken && ((SymbolToken)token2).getSymbol().equals("=")) {
                        foundNamedParameters = true;
                    }
                    if (!foundNamedParameters) continue;
                } else if (token == null || token instanceof NewLineToken) {
                    if (leftParenthesisToken != null) {
                        visitor.onException(new SyntaxException("Expected )", tIterator.getLocation()));
                    }
                    done = true;
                } else {
                    if (leftParenthesisToken == null || !(token instanceof SymbolToken) || !(symbolToken = (SymbolToken)token).getSymbol().equals(")")) continue;
                    visitor.onRightParenthesis(symbolToken);
                    tIterator.swallow();
                    done = true;
                }
                break;
            } while (ParserUtilities.parseExpression(tIterator, visitor.onArgument(token.getSpan().getStart()), false));
            if (done) break block27;
            while (true) {
                if (leftParenthesisToken == null) {
                    ParserUtilities.skipWhitespacesAndComments(tIterator);
                } else {
                    ParserUtilities.skipAllWhitespaces(tIterator);
                }
                token = tIterator.getToken();
                if (!(token instanceof ResourceToken)) break;
                tIterator.swallow();
                if (leftParenthesisToken == null) {
                    ParserUtilities.skipWhitespacesAndComments(tIterator);
                } else {
                    ParserUtilities.skipAllWhitespaces(tIterator);
                }
                token2 = tIterator.getToken();
                if (token2 instanceof SymbolToken && (s = (symbolToken = (SymbolToken)token2).getSymbol()).equals("=")) {
                    tIterator.swallow();
                    if (leftParenthesisToken == null) {
                        ParserUtilities.skipWhitespacesAndComments(tIterator);
                    } else {
                        ParserUtilities.skipAllWhitespaces(tIterator);
                    }
                    if (ParserUtilities.parseExpression(tIterator, visitor.onNamedArgument((ResourceToken)token, symbolToken), false)) {
                        continue;
                    }
                    break block27;
                }
                ** GOTO lbl-1000
                break;
            }
            if (token == null || leftParenthesisToken == null && token instanceof NewLineToken) {
                if (leftParenthesisToken != null) {
                    visitor.onException(new SyntaxException("Expected )", tIterator.getLocation()));
                }
                done = true;
            } else if (leftParenthesisToken != null && token instanceof SymbolToken && (symbolToken = (SymbolToken)token).getSymbol().equals(")")) {
                visitor.onRightParenthesis(symbolToken);
                tIterator.swallow();
                done = true;
            } else lbl-1000:
            // 2 sources

            {
                visitor.onException(new SyntaxException("Expected named argument in form: [name as URI] = [value expression]", tIterator.getLocation()));
            }
        }
        if (!done && leftParenthesisToken != null) {
            visitor.onException(new SyntaxException("Expected )", tIterator.getLocation()));
            while ((token = tIterator.getToken()) != null) {
                tIterator.swallow();
                if (!(token instanceof NewLineToken) && (!(token instanceof SymbolToken) || !((SymbolToken)token).getSymbol().equals(")"))) continue;
                break;
            }
        }
        visitor.end(tIterator.getLocation());
    }

    public static Location parseCodeBlock(ITokenIterator tIterator, ICodeBlockVisitor visitor, IndentToken indentToken) {
        Token token;
        visitor.start(tIterator.getLocation());
        visitor.setFirstIndent(indentToken);
        BlockFilterTokenIterator tIterator2 = new BlockFilterTokenIterator(tIterator);
        Location returnLocation = tIterator.getLocation();
        while ((token = tIterator2.getToken()) != null) {
            if (token instanceof IndentToken) {
                if (!((IndentToken)token).isIdenticalTo(indentToken)) break;
                tIterator2.swallow();
                returnLocation = Parser.parseConstruct(tIterator2, visitor, (IndentToken)token, false);
                continue;
            }
            tIterator2.swallow();
        }
        visitor.end(returnLocation);
        return returnLocation;
    }

    protected static void parseModel(ITokenIterator tIterator, IModelVisitor visitor, SymbolToken leftBraceToken) {
        SymbolToken symbolToken;
        boolean skipToEnd;
        block3: {
            block4: {
                Token token = null;
                skipToEnd = false;
                visitor.start(leftBraceToken.getSpan().getStart());
                visitor.onModelStart(leftBraceToken);
                tIterator.swallow();
                do {
                    String s;
                    ParserUtilities.skipAllWhitespaces(tIterator);
                    token = tIterator.getToken();
                    if (token == null) break block3;
                    if (token instanceof SymbolToken && (s = (symbolToken = (SymbolToken)token).getSymbol()).equals("}")) {
                        visitor.onModelEnd(symbolToken);
                        tIterator.swallow();
                        break block3;
                    }
                    if (!ParserUtilities.parseExpression(tIterator, visitor.onSubject(token.getSpan().getStart()), false)) break block4;
                } while (Parser.parseSeveralAttributes(tIterator, visitor));
                skipToEnd = true;
                break block3;
            }
            skipToEnd = true;
        }
        if (skipToEnd && (symbolToken = ParserUtilities.skipToClosingBrace(tIterator)) != null) {
            visitor.onModelEnd(symbolToken);
            tIterator.swallow();
        }
        visitor.end(tIterator.getLocation());
    }

    protected static SymbolToken skipToClosingBrace(ITokenIterator tIterator) {
        Token token = null;
        while ((token = tIterator.getToken()) != null) {
            if (token instanceof SymbolToken && ((SymbolToken)token).getSymbol().equals("}")) break;
            if (ParserUtilities.parseExpression(tIterator, new NullExpressionVisitor(), false)) continue;
            tIterator.swallow();
        }
        return (SymbolToken)token;
    }

    protected static void parseAnonymousModel(ITokenIterator tIterator, IAnonymousModelVisitor visitor, SymbolToken dollarSignToken) {
        visitor.start(dollarSignToken.getSpan().getStart());
        tIterator.swallow();
        Token token = tIterator.getToken();
        if (token instanceof SymbolToken) {
            SymbolToken leftBraceToken = (SymbolToken)token;
            if (leftBraceToken.getSymbol().equals("{")) {
                visitor.onModelStart(dollarSignToken, leftBraceToken);
                tIterator.swallow();
                ParserUtilities.skipAllWhitespaces(tIterator);
                Parser.parseSeveralAttributes(tIterator, visitor);
                ParserUtilities.skipAllWhitespaces(tIterator);
                token = tIterator.getToken();
                if (token instanceof SymbolToken && ((SymbolToken)token).getSymbol().equals("}")) {
                    visitor.onModelEnd((SymbolToken)token);
                    tIterator.swallow();
                } else {
                    visitor.onException(new SyntaxException("Expected }", tIterator.getLocation()));
                }
            } else {
                visitor.onException(new SyntaxException("Expected ${", token.getSpan()));
            }
        } else {
            visitor.onException(new SyntaxException("Expected ${", token.getSpan()));
        }
        visitor.end(tIterator.getLocation());
    }

    protected static void parseAskModel(ITokenIterator tIterator, IAskModelVisitor visitor, SymbolToken percentSignToken) {
        visitor.start(percentSignToken.getSpan().getStart());
        tIterator.swallow();
        Token token = tIterator.getToken();
        if (token instanceof SymbolToken) {
            SymbolToken leftBraceToken = (SymbolToken)token;
            if (leftBraceToken.getSymbol().equals("{")) {
                visitor.onModelStart(percentSignToken, leftBraceToken);
                tIterator.swallow();
                boolean foundClosingBrace = false;
                ParserUtilities.parseCondition(tIterator, visitor, null);
                while (true) {
                    ParserUtilities.skipAllWhitespaces(tIterator);
                    token = tIterator.getToken();
                    if (token == null) break;
                    if (!(token instanceof SymbolToken)) continue;
                    SymbolToken symbolToken = (SymbolToken)token;
                    String s = symbolToken.getSymbol();
                    if (s.equals("}")) {
                        visitor.onModelEnd(symbolToken);
                        tIterator.swallow();
                        foundClosingBrace = true;
                        break;
                    }
                    if (!s.equals(",")) continue;
                    tIterator.swallow();
                    ParserUtilities.parseCondition(tIterator, visitor, symbolToken);
                }
                if (!foundClosingBrace) {
                    visitor.onException(new SyntaxException("Expected }", tIterator.getLocation()));
                }
            } else {
                visitor.onException(new SyntaxException("Expected %{", tIterator.getLocation()));
            }
        } else {
            visitor.onException(new SyntaxException("Expected %{", tIterator.getLocation()));
        }
        visitor.end(tIterator.getLocation());
    }

    protected static void parseCondition(ITokenIterator tIterator, IAskModelVisitor visitor, SymbolToken commaToken) {
        ParserUtilities.skipAllWhitespaces(tIterator);
        int termCount = 0;
        Location endingLocation = tIterator.getLocation();
        visitor.onConditionStart(commaToken);
        while (true) {
            SymbolToken symbolToken;
            String s;
            ParserUtilities.skipAllWhitespaces(tIterator);
            Token token = tIterator.getToken();
            if (token instanceof SymbolToken && ((s = (symbolToken = (SymbolToken)token).getSymbol()).equals("}") || s.equals(",")) || !ParserUtilities.parseExpression(tIterator, visitor.onConditionTerm(token.getSpan().getStart()), false)) break;
            endingLocation = tIterator.getLocation();
            ++termCount;
        }
        visitor.onConditionEnd(endingLocation);
        if (commaToken != null && termCount == 0) {
            visitor.onException(new SyntaxException("Expected condition", tIterator.getLocation()));
        }
    }

    protected static boolean parseSubExpression(ITokenIterator tIterator, ISubExpressionVisitor visitor, boolean allowEmptyExpression) {
        visitor.start(tIterator.getLocation());
        boolean processed = false;
        boolean swallow = true;
        Token token = tIterator.getToken();
        if (token instanceof SymbolToken) {
            SymbolToken backquoteT = null;
            if (((SymbolToken)token).getSymbol().equals("`")) {
                backquoteT = (SymbolToken)token;
                tIterator.swallow();
                token = tIterator.getToken();
            }
            if (token instanceof GenericToken) {
                visitor.onIdentifier(backquoteT, ParserUtilities.parseCompoundGenericToken(tIterator, token, true));
                swallow = false;
                processed = true;
            } else if (token instanceof SymbolToken) {
                swallow = false;
                if ("@$%{}()[];".indexOf(((SymbolToken)token).getSymbol()) < 0) {
                    visitor.onIdentifier(backquoteT, ParserUtilities.parseCompoundGenericToken(tIterator, token, true));
                    processed = true;
                }
            }
        } else if (token instanceof ResourceToken) {
            visitor.onResource((ResourceToken)token);
            processed = true;
        } else if (token instanceof GenericToken) {
            visitor.onIdentifier(null, ParserUtilities.parseCompoundGenericToken(tIterator, token, true));
            swallow = false;
            processed = true;
        }
        if (processed) {
            if (swallow) {
                tIterator.swallow();
            }
        } else if (!allowEmptyExpression) {
            visitor.onException(new SyntaxException("Expected identifier or resource, possibly backquoted", tIterator.getLocation()));
        }
        visitor.end(tIterator.getLocation());
        return processed;
    }

    protected static void parseList(ITokenIterator tIterator, IListVisitor visitor, SymbolToken atSignToken) {
        visitor.start(atSignToken.getSpan().getStart());
        tIterator.swallow();
        Token token = tIterator.getToken();
        if (token instanceof SymbolToken) {
            SymbolToken leftParenthesisToken = (SymbolToken)token;
            if (leftParenthesisToken.getSymbol().equals("(")) {
                visitor.onLeftParenthesis(atSignToken, leftParenthesisToken);
                tIterator.swallow();
                boolean foundRightParenthesis = false;
                do {
                    SymbolToken symbolToken;
                    String s;
                    ParserUtilities.skipAllWhitespaces(tIterator);
                    token = tIterator.getToken();
                    if (token == null) break;
                    if (!(token instanceof SymbolToken) || !(s = (symbolToken = (SymbolToken)token).getSymbol()).equals(")")) continue;
                    visitor.onRightParenthesis(symbolToken);
                    tIterator.swallow();
                    foundRightParenthesis = true;
                    break;
                } while (ParserUtilities.parseExpression(tIterator, visitor.onItem(token.getSpan().getStart()), false));
                if (!foundRightParenthesis) {
                    visitor.onException(new SyntaxException("Expected )", tIterator.getLocation()));
                }
            } else {
                visitor.onException(new SyntaxException("Expected @(", tIterator.getLocation()));
            }
        } else {
            visitor.onException(new SyntaxException("Expected @(", tIterator.getLocation()));
        }
        visitor.end(tIterator.getLocation());
    }
}

