/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.parser2;

import edu.mit.lcs.haystack.adenine.parser2.BlockFilterTokenIterator;
import edu.mit.lcs.haystack.adenine.parser2.IAnonymousModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IAttributeVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ICodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IConstructParser;
import edu.mit.lcs.haystack.adenine.parser2.IModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ITopLevelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ParserUtilities;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.parser2.constructs.AssignmentParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.BlockParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.BreakParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.CallParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.ContinueParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.ForParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.FunctionParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.IfParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.ImportJavaParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.MainParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.MethodParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.ReturnParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.SkipBlockParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.VarParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.WhileParser;
import edu.mit.lcs.haystack.adenine.parser2.constructs.WithParser;
import edu.mit.lcs.haystack.adenine.tokenizer.CommentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ErrorToken;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.IScannerVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.ITokenIterator;
import edu.mit.lcs.haystack.adenine.tokenizer.IndentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.NewLineToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;
import edu.mit.lcs.haystack.adenine.tokenizer.Tokenizer;
import edu.mit.lcs.haystack.adenine.tokenizer.WhitespaceToken;
import java.io.Reader;
import java.util.HashMap;

public final class Parser {
    protected static HashMap s_constructParsers = new HashMap();
    public static String s_compoundGenericTokenExcepts;

    static {
        s_constructParsers.put("=", new AssignmentParser());
        s_constructParsers.put("block", new BlockParser());
        s_constructParsers.put("break", new BreakParser());
        s_constructParsers.put("call", new CallParser());
        s_constructParsers.put("continue", new ContinueParser());
        s_constructParsers.put("for", new ForParser());
        s_constructParsers.put("function", new FunctionParser());
        s_constructParsers.put("if", new IfParser());
        s_constructParsers.put("importjava", new ImportJavaParser());
        s_constructParsers.put("method", new MethodParser());
        s_constructParsers.put("main", new MainParser());
        s_constructParsers.put("skipBlock", new SkipBlockParser());
        s_constructParsers.put("return", new ReturnParser());
        s_constructParsers.put("uniqueMethod", new MethodParser());
        s_constructParsers.put("var", new VarParser());
        s_constructParsers.put("while", new WhileParser());
        s_constructParsers.put("with", new WithParser());
        s_compoundGenericTokenExcepts = "<>()[]{}.,;?@$%";
    }

    public static void parse(IScannerVisitor sVisitor, ITopLevelVisitor pVisitor, Reader reader) {
        if (sVisitor == null) {
            throw new NullPointerException("sVisitor is null");
        }
        if (pVisitor == null) {
            throw new NullPointerException("pVisitor is null");
        }
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        Parser.parse(new Tokenizer(reader, sVisitor), pVisitor);
    }

    public static void parse(ITokenIterator tokenIterator, ITopLevelVisitor pVisitor) {
        if (tokenIterator == null) {
            throw new NullPointerException("tokenIterator is null");
        }
        if (pVisitor == null) {
            throw new NullPointerException("pVisitor is null");
        }
        Parser.parseTopLevel(tokenIterator, pVisitor);
    }

    protected static void parseTopLevel(ITokenIterator tIterator, ITopLevelVisitor visitor) {
        Token token;
        visitor.start(tIterator.getLocation());
        while ((token = tIterator.getToken()) != null) {
            if (token instanceof IndentToken) {
                visitor.onException(new SyntaxException("Indentation not allowed at top level", token.getSpan()));
                BlockFilterTokenIterator tIterator2 = new BlockFilterTokenIterator(tIterator);
                while (tIterator2.getToken() != null) {
                    tIterator2.swallow();
                }
                continue;
            }
            if (token instanceof CommentToken || token instanceof WhitespaceToken || token instanceof NewLineToken) {
                tIterator.swallow();
                continue;
            }
            if (token instanceof SymbolToken) {
                SymbolToken symbolToken = (SymbolToken)token;
                String s = symbolToken.getSymbol();
                if (s.equals("@")) {
                    Parser.parsePragma(tIterator, visitor, symbolToken);
                    continue;
                }
            } else if (token instanceof ErrorToken) {
                visitor.onException(new SyntaxException("Bad token", token.getSpan()));
                ParserUtilities.skipToNextLine(tIterator);
                continue;
            }
            Parser.parseConstruct(tIterator, visitor, null, true);
        }
        visitor.end(tIterator.getLocation());
    }

    protected static void parsePragma(ITokenIterator tIterator, ITopLevelVisitor visitor, SymbolToken atSignToken) {
        tIterator.swallow();
        Token token = tIterator.getToken();
        if (token instanceof GenericToken) {
            GenericToken genericToken = (GenericToken)token;
            String s = genericToken.getContent();
            if (s.equals("base")) {
                boolean error = true;
                tIterator.swallow();
                ParserUtilities.skipWhitespacesAndComments(tIterator);
                token = tIterator.getToken();
                if (token instanceof ResourceToken) {
                    visitor.onBase(atSignToken, genericToken, (ResourceToken)token);
                    tIterator.swallow();
                    ParserUtilities.skipWhitespacesAndComments(tIterator);
                    token = tIterator.getToken();
                    if (token instanceof NewLineToken) {
                        tIterator.swallow();
                        error = false;
                    }
                }
                if (error) {
                    visitor.onException(new SyntaxException("@base declaration must be of form: @base [URI] ", tIterator.getLocation()));
                    ParserUtilities.skipToNextLine(tIterator);
                }
            } else if (s.equals("prefix")) {
                ResourceToken prefix;
                boolean error = true;
                tIterator.swallow();
                ParserUtilities.skipWhitespacesAndComments(tIterator);
                token = tIterator.getToken();
                if (token instanceof ResourceToken && (prefix = (ResourceToken)token).isPrefixed() && prefix.getSuffix().length() == 0) {
                    tIterator.swallow();
                    ParserUtilities.skipWhitespacesAndComments(tIterator);
                    token = tIterator.getToken();
                    if (token instanceof ResourceToken) {
                        visitor.onPrefix(atSignToken, genericToken, prefix, (ResourceToken)token);
                        tIterator.swallow();
                        ParserUtilities.skipWhitespacesAndComments(tIterator);
                        token = tIterator.getToken();
                        if (token instanceof NewLineToken) {
                            tIterator.swallow();
                            error = false;
                        }
                    }
                }
                if (error) {
                    visitor.onException(new SyntaxException("@prefix declaration must be of form: @prefix [prefix:] [expanded URI]", tIterator.getLocation()));
                    ParserUtilities.skipToNextLine(tIterator);
                }
            } else {
                visitor.onException(new SyntaxException("Unrecognized pragma keyword '" + s + "'", genericToken.getSpan()));
                ParserUtilities.skipToNextLine(tIterator);
            }
        } else {
            visitor.onException(new SyntaxException("Expected pragma keyword after @. Use @base or @prefix", atSignToken.getSpan()));
            ParserUtilities.skipToNextLine(tIterator);
        }
    }

    protected static boolean parseSeveralAttributes(ITokenIterator tIterator, IModelVisitor visitor) {
        block2: {
            SymbolToken symbolToken;
            ParserUtilities.skipAllWhitespaces(tIterator);
            if (!Parser.parseAttribute(tIterator, visitor.onAttribute(null), null)) {
                return false;
            }
            do {
                String s;
                ParserUtilities.skipAllWhitespaces(tIterator);
                Token token = tIterator.getToken();
                if (!(token instanceof SymbolToken) || !(s = (symbolToken = (SymbolToken)token).getSymbol()).equals(";")) break block2;
            } while (Parser.parseAttribute(tIterator, visitor.onAttribute(symbolToken), symbolToken));
            return false;
        }
        return true;
    }

    protected static void parseSeveralAttributes(ITokenIterator tIterator, IAnonymousModelVisitor visitor) {
        Parser.parseAttribute(tIterator, visitor.onAttribute(null), null);
        while (true) {
            SymbolToken symbolToken;
            String s;
            ParserUtilities.skipAllWhitespaces(tIterator);
            Token token = tIterator.getToken();
            if (!(token instanceof SymbolToken) || !(s = (symbolToken = (SymbolToken)token).getSymbol()).equals(";")) break;
            Parser.parseAttribute(tIterator, visitor.onAttribute(symbolToken), symbolToken);
        }
    }

    public static boolean parseAttribute(ITokenIterator tIterator, IAttributeVisitor visitor, SymbolToken semicolonToken) {
        Token token;
        boolean r = false;
        visitor.start(tIterator.getLocation());
        if (semicolonToken != null) {
            tIterator.swallow();
            ParserUtilities.skipAllWhitespaces(tIterator);
        }
        if (!((token = tIterator.getToken()) == null || token instanceof SymbolToken && ((SymbolToken)token).getSymbol().equals("}") || !(r = ParserUtilities.parseExpression(tIterator, visitor.onPredicate(token.getSpan().getStart()), false)))) {
            ParserUtilities.skipAllWhitespaces(tIterator);
            r = ParserUtilities.parseExpression(tIterator, visitor.onObject(token.getSpan().getStart()), false);
        }
        visitor.end(tIterator.getLocation());
        return r;
    }

    static Location parseConstruct(ITokenIterator tIterator, ICodeBlockVisitor visitor, IndentToken indentToken, boolean allowAdd) {
        Token token = tIterator.getToken();
        Location endLocation = null;
        if (ParserUtilities.isPotentialIdentifier(token)) {
            GenericToken token2 = ParserUtilities.parseCompoundGenericToken(tIterator, token, false);
            String s = token2.getContent();
            IConstructParser parser = (IConstructParser)s_constructParsers.get(s);
            if (parser == null) {
                parser = new CallParser();
                s = "call";
            }
            endLocation = parser.parseConstruct(tIterator, visitor.onConstruct(token2.getSpan().getStart(), s), indentToken);
        } else if (token instanceof ResourceToken) {
            new CallParser().parseConstruct(tIterator, visitor.onConstruct(token.getSpan().getStart(), "call"), indentToken);
        }
        return endLocation != null ? endLocation : tIterator.getLocation();
    }
}

