/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.parser2;

import edu.mit.lcs.haystack.adenine.tokenizer.CommentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ITokenIterator;
import edu.mit.lcs.haystack.adenine.tokenizer.IndentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.NewLineToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Span;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;
import edu.mit.lcs.haystack.adenine.tokenizer.WhitespaceToken;
import java.util.LinkedList;

public class BlockFilterTokenIterator
implements ITokenIterator {
    ITokenIterator m_tokenIterator;
    IndentToken m_indentToken;
    LinkedList m_tokens = new LinkedList();
    boolean m_eof = false;
    boolean m_newLine = true;

    public BlockFilterTokenIterator(ITokenIterator tokenIterator) {
        this.m_tokenIterator = tokenIterator;
        Token token = this.m_tokenIterator.getToken();
        if (token instanceof IndentToken) {
            this.m_indentToken = (IndentToken)token;
        } else {
            Location l = token.getSpan().getStart();
            Span span = new Span(l, l);
            this.m_indentToken = new IndentToken(span);
        }
    }

    public Token getToken() {
        return this.getToken(0);
    }

    public Token getToken(int ahead) {
        this.fetchSeveralTokens(ahead + 1);
        if (ahead < this.m_tokens.size()) {
            return (Token)this.m_tokens.get(ahead);
        }
        return null;
    }

    public void swallow() {
        this.swallow(1);
    }

    public void swallow(int count) {
        this.fetchSeveralTokens(count);
        int actualCount = Math.min(count, this.m_tokens.size());
        while (actualCount > 0) {
            this.m_tokens.remove(0);
            this.m_tokenIterator.swallow();
            --actualCount;
        }
    }

    protected void fetchSeveralTokens(int count) {
        if (!this.m_eof && count > this.m_tokens.size()) {
            while (this.m_tokens.size() < count) {
                Token token = this.m_tokenIterator.getToken(this.m_tokens.size());
                if (!(!this.m_newLine || token instanceof WhitespaceToken || token instanceof NewLineToken || token instanceof CommentToken || token instanceof IndentToken && this.m_indentToken.isIdenticalOrOuterLevelOf((IndentToken)token))) {
                    this.m_eof = true;
                    break;
                }
                this.m_newLine = token instanceof NewLineToken;
                this.m_tokens.add(token);
            }
        }
    }

    public Location getLocation() {
        return this.m_tokenIterator.getLocation();
    }
}

