/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.parser;

import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SyntaxException;
import edu.mit.lcs.haystack.adenine.parser.LiteralToken;
import edu.mit.lcs.haystack.adenine.parser.Token;

public class StringToken
extends Token {
    public StringToken(int line) {
        this.m_line = line;
    }

    public int processToken(String str, int i) throws AdenineException {
        while (i < str.length()) {
            char ch;
            if ((ch = str.charAt(i++)) == '\'') {
                return i;
            }
            if (ch == '\\') {
                if (i == str.length()) {
                    throw new SyntaxException("Unfinished escape sequence", this.m_line);
                }
                ch = LiteralToken.processEscapeSequence(str.charAt(i++));
            }
            this.m_token = String.valueOf(this.m_token) + ch;
        }
        throw new SyntaxException("Unclosed quotation", this.m_line);
    }

    public String toString() {
        return "'" + this.m_token + "'";
    }

    public String prettyPrint(int tablevel) {
        return "'" + LiteralToken.unescapeString(this.m_token) + "'";
    }
}

