/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.parser;

import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SyntaxException;
import edu.mit.lcs.haystack.adenine.parser.BackQuoteToken;
import edu.mit.lcs.haystack.adenine.parser.Block;
import edu.mit.lcs.haystack.adenine.parser.BlockException;
import edu.mit.lcs.haystack.adenine.parser.BracedToken;
import edu.mit.lcs.haystack.adenine.parser.BracketedToken;
import edu.mit.lcs.haystack.adenine.parser.ContainerToken;
import edu.mit.lcs.haystack.adenine.parser.DereferencementToken;
import edu.mit.lcs.haystack.adenine.parser.IdentifierToken;
import edu.mit.lcs.haystack.adenine.parser.IndentToken;
import edu.mit.lcs.haystack.adenine.parser.IndexToken;
import edu.mit.lcs.haystack.adenine.parser.InputLine;
import edu.mit.lcs.haystack.adenine.parser.Line;
import edu.mit.lcs.haystack.adenine.parser.LiteralToken;
import edu.mit.lcs.haystack.adenine.parser.ParenthesizedToken;
import edu.mit.lcs.haystack.adenine.parser.SemicolonToken;
import edu.mit.lcs.haystack.adenine.parser.StringToken;
import edu.mit.lcs.haystack.adenine.parser.Token;
import edu.mit.lcs.haystack.adenine.parser.URIToken;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class Parser {
    static String special = " \t@{}[]\"();<>$%'`";

    public static void main(String[] args) {
        try {
            ArrayList al = Parser.tokenize(new FileReader(args[0]));
            System.out.println(Parser.blockify(al).prettyPrint(-1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String escapeQuotes(StringBuffer tq) {
        return Parser.escapeQuotes(tq.toString());
    }

    public static String escapeQuotes(String tq) {
        StringBuffer tqNew = new StringBuffer();
        int i = 0;
        while (i < tq.length()) {
            char ch = tq.charAt(i);
            if (ch == '\"') {
                tqNew.append("\\\"");
            } else if (ch == '\'') {
                tqNew.append("\\'");
            } else if (ch == '\\') {
                if (i < tq.length() - 1) {
                    tqNew.append(ch);
                    tqNew.append(tq.charAt(++i));
                } else {
                    tqNew.append(ch);
                }
            } else {
                tqNew.append(ch);
            }
            ++i;
        }
        return tqNew.toString();
    }

    public static ArrayList tokenize(Reader input) throws AdenineException {
        ArrayList tokens = new ArrayList();
        BufferedReader reader = new BufferedReader(input);
        int lineno = 0;
        ArrayList<InputLine> lines = new ArrayList<InputLine>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String l2 = line.trim();
                if (l2.length() == 0) {
                    ++lineno;
                    continue;
                }
                if (l2.charAt(0) == '#') {
                    ++lineno;
                    continue;
                }
                int tq1 = line.indexOf("'''");
                int tq2 = line.indexOf("\"\"\"");
                int tqStart = -1;
                String tqDelimiter = null;
                if (tq1 != -1) {
                    if (tq2 != -1 && tq2 < tq1) {
                        tq1 = -1;
                    } else {
                        tq2 = -1;
                        tqDelimiter = "'''";
                        tqStart = tq1;
                    }
                }
                if (tq2 != -1) {
                    tqDelimiter = "\"\"\"";
                    tqStart = tq2;
                }
                if (tqStart != -1) {
                    StringBuffer tq = new StringBuffer();
                    int tqEnd = line.indexOf(tqDelimiter, tqStart + 3);
                    if (tqEnd != -1) {
                        line = String.valueOf(line.substring(0, tqStart)) + tqDelimiter.charAt(0) + Parser.escapeQuotes(line.substring(tqStart + 3, tqEnd)) + tqDelimiter.charAt(0) + line.substring(tqEnd + 3);
                    } else {
                        String startLine = line;
                        tq.append(line.substring(tqStart + 3));
                        tq.append("\\\n");
                        while ((line = reader.readLine()) != null) {
                            ++lineno;
                            tqEnd = line.indexOf(tqDelimiter);
                            if (tqEnd != -1) {
                                tq.append(line.substring(0, tqEnd));
                                break;
                            }
                            tq.append(line);
                            tq.append("\\\n");
                        }
                        if (line == null) {
                            throw new SyntaxException("Unexpected end of file found in " + tqDelimiter + " expression");
                        }
                        line = String.valueOf(startLine.substring(0, tqStart)) + tqDelimiter.charAt(0) + Parser.escapeQuotes(tq) + tqDelimiter.charAt(0) + line.substring(tqEnd + 3);
                    }
                }
                StringBuffer line2 = new StringBuffer();
                boolean inContinuation = false;
                do {
                    ++lineno;
                    int len = line.length();
                    if (!inContinuation && len > 1 && line.indexOf("\\\\") == 0) {
                        inContinuation = true;
                        line = line.substring(2);
                        len -= 2;
                    }
                    if (!inContinuation) {
                        if (len > 0 && line.charAt(len - 1) == '\\') {
                            line2.append(line.substring(0, len - 1));
                            line2.append(" ");
                            continue;
                        }
                        line2.append(line);
                        break;
                    }
                    if (len > 1 && line.charAt(len - 1) == '\\' && line.charAt(len - 2) == '\\') {
                        inContinuation = false;
                        line = line.substring(0, len - 2);
                        line2.append(line);
                        break;
                    }
                    line2.append(line);
                    line2.append(" ");
                } while ((line = reader.readLine()) != null);
                String line3 = line2.toString();
                lines.add(new InputLine(line3, lineno));
            }
        }
        catch (IOException l2) {
            // empty catch block
        }
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            InputLine il = (InputLine)i.next();
            Parser.tokenizeHelper(il, i, tokens, false, false, false);
        }
        return tokens;
    }

    static boolean isURIIdentifier(String str) {
        return str.indexOf(":") != -1 || str.indexOf("?") == 0;
    }

    static Token convertBackQuotes(Token token) throws AdenineException {
        ArrayList al = new ArrayList();
        al.add(token);
        al = Parser.convertBackQuotes(al);
        return (Token)al.get(0);
    }

    static ArrayList convertBackQuotes(ArrayList tokens) throws AdenineException {
        ListIterator i = tokens.listIterator(tokens.size());
        ArrayList<Token> output = new ArrayList<Token>();
        while (i.hasPrevious()) {
            Token token = (Token)i.previous();
            if (token instanceof BackQuoteToken) {
                if (output.size() == 0) {
                    throw new SyntaxException("Invalid backquote", token.m_line);
                }
                Token token2 = (Token)output.get(0);
                if (token2 instanceof IndentToken || token2 instanceof SemicolonToken) {
                    throw new SyntaxException("Invalid backquote", token.m_line);
                }
                ((BackQuoteToken)token).setToken(token2);
                output.set(0, token);
                continue;
            }
            if (token instanceof ContainerToken) {
                ContainerToken ct = (ContainerToken)token;
                ct.m_tokens = Parser.convertBackQuotes(ct.m_tokens);
                output.add(0, ct);
                continue;
            }
            if (token instanceof DereferencementToken) {
                DereferencementToken dt = (DereferencementToken)token;
                dt.m_base = Parser.convertBackQuotes(dt.m_base);
                dt.m_member = Parser.convertBackQuotes(dt.m_member);
                output.add(0, dt);
                continue;
            }
            if (token instanceof IndexToken) {
                IndexToken it = (IndexToken)token;
                it.m_base = Parser.convertBackQuotes(it.m_base);
                it.m_index = Parser.convertBackQuotes(it.m_index);
                output.add(0, it);
                continue;
            }
            output.add(0, token);
        }
        return output;
    }

    static ArrayList convertDotsBrackets(ArrayList tokens) throws AdenineException {
        ArrayList<Token> al = new ArrayList<Token>();
        Stack s = new Stack();
        int i = tokens.size() - 1;
        while (i >= 0) {
            s.push(tokens.get(i));
            --i;
        }
        Token last = null;
        while (!s.isEmpty()) {
            DereferencementToken dt;
            Token t = (Token)s.pop();
            if (t instanceof ContainerToken) {
                ContainerToken ct = (ContainerToken)t;
                ct.m_tokens = Parser.convertDotsBrackets(ct.m_tokens);
            }
            if (t instanceof IdentifierToken) {
                if (!Parser.isURIIdentifier(t.m_token)) {
                    int i2 = t.m_token.indexOf(".");
                    try {
                        Double.parseDouble(t.m_token);
                    }
                    catch (NumberFormatException e) {
                        if (t.m_token.equals(".")) {
                            if (last == null) {
                                throw new SyntaxException("Dereferenced expression missing base", t.m_line);
                            }
                            if (last instanceof DereferencementToken) {
                                DereferencementToken dt2 = (DereferencementToken)last;
                                if (dt2.m_member == null) {
                                    throw new SyntaxException("Dereferenced expression incomplete", t.m_line);
                                }
                            }
                            last = new DereferencementToken(last, null);
                            continue;
                        }
                        if (i2 != -1) {
                            if (i2 == 0) {
                                s.push(new IdentifierToken(t.m_token.substring(1), t.m_line));
                                s.push(new IdentifierToken(".", t.m_line));
                                continue;
                            }
                            if (i2 != t.m_token.length() - 1) {
                                s.push(new IdentifierToken(t.m_token.substring(i2 + 1), t.m_line));
                            }
                            s.push(new IdentifierToken(".", t.m_line));
                            s.push(new IdentifierToken(t.m_token.substring(0, i2), t.m_line));
                            continue;
                        }
                    }
                }
            } else if (t instanceof BracketedToken) {
                if (last == null) {
                    throw new SyntaxException("Indexed expression missing base", t.m_line);
                }
                if (last instanceof DereferencementToken) {
                    dt = (DereferencementToken)last;
                    if (dt.m_member == null) {
                        throw new SyntaxException("Dereferenced expression incomplete", t.m_line);
                    }
                }
                BracketedToken bt = (BracketedToken)t;
                if (bt.m_tokens.size() != 1) {
                    throw new SyntaxException("Only one index supported on an object", bt.m_line);
                }
                last = new IndexToken(last, (Token)bt.m_tokens.get(0));
                continue;
            }
            if (last != null) {
                if (last instanceof DereferencementToken) {
                    dt = (DereferencementToken)last;
                    if (dt.m_member != null) {
                        al.add(last);
                        last = t;
                        continue;
                    }
                    dt.m_member = t;
                    continue;
                }
                al.add(last);
                last = t;
                continue;
            }
            last = t;
        }
        if (last != null) {
            if (last instanceof DereferencementToken) {
                DereferencementToken dt = (DereferencementToken)last;
                if (dt.m_member == null) {
                    throw new SyntaxException("Dereferenced expression incomplete", dt.m_line);
                }
            }
            al.add(last);
        }
        return al;
    }

    static InputLine tokenizeHelper(InputLine il, Iterator ili, ArrayList tokens, boolean inParens, boolean inBrackets, boolean inBraces) throws AdenineException {
        int startLine = il.m_lineno;
        if (il.m_pos == 0) {
            IndentToken it = new IndentToken(il.m_lineno);
            il.m_str = it.processIndent(il.m_str);
            tokens.add(it);
        }
        String ident = "";
        boolean dollar = false;
        boolean atSign = false;
        boolean percent = false;
        while (true) {
            char ch = ' ';
            if (il.m_pos >= il.m_str.length()) {
                if (!inBraces && !inParens && !inBrackets) break;
                try {
                    il = (InputLine)ili.next();
                }
                catch (NoSuchElementException nsee) {
                    char chErr = inBraces ? (char)'}' : (inParens ? (char)')' : ']');
                    throw new SyntaxException("Unexpected end of file searching for closing " + chErr + " opened on line " + startLine, il.m_lineno);
                }
            } else {
                ch = il.m_str.charAt(il.m_pos++);
            }
            if (atSign && ch != '(') {
                ident = String.valueOf(ident) + '@';
                atSign = false;
            }
            if (special.indexOf(ch) == -1) {
                ident = String.valueOf(ident) + ch;
                continue;
            }
            if (ident.length() > 0) {
                tokens.add(new IdentifierToken(ident, il.m_lineno));
                ident = "";
            }
            if (ch == '$') {
                if (dollar) {
                    throw new SyntaxException("Double $$", il.m_lineno);
                }
                dollar = true;
                percent = false;
                atSign = false;
                continue;
            }
            if (ch == '%') {
                if (percent) {
                    throw new SyntaxException("Double %%", il.m_lineno);
                }
                percent = true;
                dollar = false;
                atSign = false;
                continue;
            }
            if (ch == '@') {
                if (atSign) {
                    throw new SyntaxException("Double @@", il.m_lineno);
                }
                atSign = true;
                dollar = false;
                percent = false;
                continue;
            }
            if ((dollar || percent) && ch != '{') {
                throw new SyntaxException("Misplaced " + (percent ? "%" : "$"), il.m_lineno);
            }
            switch (ch) {
                case '{': {
                    ContainerToken bt = new BracedToken(il.m_lineno);
                    bt.m_dollar = dollar;
                    bt.m_percent = percent;
                    il = Parser.tokenizeHelper(il, ili, bt.m_tokens, false, false, true);
                    tokens.add(bt);
                    break;
                }
                case ';': {
                    tokens.add(new SemicolonToken(il.m_lineno));
                    break;
                }
                case '`': {
                    tokens.add(new BackQuoteToken(il.m_lineno));
                    break;
                }
                case '>': {
                    throw new SyntaxException("Mismatched >", il.m_lineno);
                }
                case '}': {
                    if (!inBraces) {
                        throw new SyntaxException("Mismatched }", il.m_lineno);
                    }
                    return il;
                }
                case '(': {
                    ParenthesizedToken pt = new ParenthesizedToken(il.m_lineno);
                    if (atSign) {
                        pt.m_prefix = (char)64;
                    }
                    il = Parser.tokenizeHelper(il, ili, pt.m_tokens, true, false, false);
                    tokens.add(pt);
                    break;
                }
                case ')': {
                    if (!inParens) {
                        throw new SyntaxException("Mismatched )", il.m_lineno);
                    }
                    return il;
                }
                case '[': {
                    ContainerToken bt = new BracketedToken(il.m_lineno);
                    il = Parser.tokenizeHelper(il, ili, ((BracketedToken)bt).m_tokens, false, true, false);
                    tokens.add(bt);
                    break;
                }
                case ']': {
                    if (!inBrackets) {
                        throw new SyntaxException("Mismatched ]", il.m_lineno);
                    }
                    return il;
                }
                case '<': {
                    URIToken urit = new URIToken(il.m_lineno);
                    il.m_pos = urit.processToken(il.m_str, il.m_pos);
                    tokens.add(urit);
                    break;
                }
                case '\"': {
                    Token lt = new LiteralToken(il.m_lineno);
                    il.m_pos = ((LiteralToken)lt).processToken(il.m_str, il.m_pos);
                    tokens.add(lt);
                    break;
                }
                case '\'': {
                    Token lt = new StringToken(il.m_lineno);
                    il.m_pos = ((StringToken)lt).processToken(il.m_str, il.m_pos);
                    tokens.add(lt);
                }
            }
            atSign = false;
            percent = false;
            dollar = false;
        }
        if (inBraces) {
            throw new SyntaxException("{ without matching }", il.m_lineno);
        }
        if (inParens) {
            throw new SyntaxException("( without matching )", il.m_lineno);
        }
        if (inBrackets) {
            throw new SyntaxException("[ without matching ]", il.m_lineno);
        }
        if (dollar) {
            throw new SyntaxException("Extra $ at end of line", il.m_lineno);
        }
        if (ident.length() > 0) {
            tokens.add(new IdentifierToken(ident, il.m_lineno));
        }
        return il;
    }

    public static Block blockify(ArrayList tokens) throws AdenineException {
        Iterator i = tokens.iterator();
        if (!i.hasNext()) {
            return new Block();
        }
        try {
            return Parser.blockifyHelper(i, (IndentToken)i.next(), null);
        }
        catch (BlockException be) {
            be.printStackTrace();
            return new Block();
        }
    }

    static Block blockifyHelper(Iterator i, IndentToken indent, Block parent) throws BlockException, AdenineException {
        Block block = new Block();
        block.m_parent = parent;
        block.m_indent = indent.m_token;
        block.m_startline = indent.m_line;
        Line line = new Line();
        line.m_lineno = indent.m_line;
        if (parent != null) {
            parent.m_items.add(block);
        }
        while (i.hasNext()) {
            Token t = (Token)i.next();
            if (t instanceof IndentToken) {
                if (line.m_tokens.size() > 0) {
                    line.m_tokens = Parser.convertBackQuotes(Parser.convertDotsBrackets(line.m_tokens));
                    block.m_items.add(line);
                    line = new Line();
                }
                if (t.m_token.equals(block.m_indent)) {
                    line.m_lineno = t.m_line;
                    continue;
                }
                if (parent != null && parent.findIndent(t.m_token)) {
                    throw new BlockException(t.m_token, t.m_line);
                }
                try {
                    Parser.blockifyHelper(i, (IndentToken)t, block);
                    continue;
                }
                catch (BlockException be) {
                    if (be.m_indent.equals(block.m_indent)) {
                        line = new Line();
                        line.m_lineno = be.m_lineno;
                        continue;
                    }
                    throw be;
                }
            }
            line.m_tokens.add(t);
        }
        if (line.m_tokens.size() > 0) {
            line.m_tokens = Parser.convertBackQuotes(Parser.convertDotsBrackets(line.m_tokens));
            block.m_items.add(line);
        }
        return block;
    }
}

