/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.interpreter;

import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.UnboundIdentifierException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class VariableFrame {
    public String m_frameName = Interpreter.generateIdentifier();
    public HashSet m_variables = new HashSet();
    public VariableFrame m_parentFrame = null;
    public HashSet m_defaultEnvironmentVariables = new HashSet();

    public String resolveVariableName(String name) throws UnboundIdentifierException {
        if (this.m_variables.contains(name)) {
            return Interpreter.filterSymbols(String.valueOf(this.m_frameName) + "_" + name);
        }
        if (this.m_parentFrame != null) {
            return this.m_parentFrame.resolveVariableName(name);
        }
        if (Interpreter.s_defaultEnvironment.isBound(name)) {
            this.m_defaultEnvironmentVariables.add(name);
            return Interpreter.filterSymbols(String.valueOf(this.m_frameName) + "_" + name);
        }
        throw new UnboundIdentifierException(name);
    }

    public String generateVariableName(String name) {
        try {
            return this.resolveVariableName(name);
        }
        catch (AdenineException ae) {
            this.m_variables.add(name);
            return Interpreter.filterSymbols(String.valueOf(this.m_frameName) + "_" + name);
        }
    }

    public void mapVariables(HashMap variables) {
        if (this.m_parentFrame != null) {
            this.m_parentFrame.mapVariables(variables);
        }
        Iterator i = this.m_variables.iterator();
        while (i.hasNext()) {
            String var = (String)i.next();
            variables.put(var, this.m_frameName);
        }
    }

    public VariableFrame flatten(String target, StringBuffer buffer) throws AdenineException {
        VariableFrame frame = new VariableFrame();
        HashMap variables = new HashMap();
        this.mapVariables(variables);
        Iterator i = variables.keySet().iterator();
        while (i.hasNext()) {
            String var = (String)i.next();
            buffer.append(target);
            buffer.append(".");
            buffer.append(frame.m_frameName);
            buffer.append("_");
            buffer.append(Interpreter.filterSymbols(var));
            buffer.append(" = ");
            buffer.append((String)variables.get(var));
            buffer.append("_");
            buffer.append(Interpreter.filterSymbols(var));
            buffer.append(";\n");
        }
        return frame;
    }
}

