/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.interpreter;

import edu.mit.lcs.haystack.adenine.interpreter.Cell;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.adenine.query.DefaultQueryEngine;
import edu.mit.lcs.haystack.adenine.query.IQueryEngine;
import edu.mit.lcs.haystack.proxy.IServiceAccessor;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.security.Identity;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;

public class DynamicEnvironment
extends Environment {
    public DynamicEnvironment() {
        this.setOutput(new PrintWriter(System.out, true));
        this.setInput(new BufferedReader(new InputStreamReader(System.in)));
        this.setQueryEngine(new DefaultQueryEngine());
        this.setIdentity(null);
    }

    public DynamicEnvironment(IRDFContainer rdfc) {
        this();
        this.setSource(rdfc);
        this.setTarget(rdfc);
    }

    public DynamicEnvironment(IRDFContainer rdfc, IServiceAccessor sa) {
        this(rdfc);
        this.setServiceAccessor(sa);
    }

    public Object clone() {
        DynamicEnvironment e = new DynamicEnvironment();
        e.m_bindings = (HashMap)this.m_bindings.clone();
        return e;
    }

    public Message getMessageIfAny() {
        if (this.isBound("__message__")) {
            return (Message)this.getValue("__message__");
        }
        return null;
    }

    public IQueryEngine getQueryEngine() {
        return (IQueryEngine)this.getValue("__queryengine__");
    }

    public IRDFContainer getSource() {
        return (IRDFContainer)this.getValue("__source__");
    }

    public IRDFContainer getTarget() {
        return (IRDFContainer)this.getValue("__target__");
    }

    public IRDFContainer getInstructionSource() {
        return (IRDFContainer)this.getValue("__instructionsource__");
    }

    public IServiceAccessor getServiceAccessor() {
        return (IServiceAccessor)this.getValue("__serviceaccessor__");
    }

    public PrintWriter getOutput() {
        return (PrintWriter)this.getValue("__output__");
    }

    public BufferedReader getInput() {
        return (BufferedReader)this.getValue("__input__");
    }

    public Identity getIdentity() {
        return (Identity)this.getValue("__identity__");
    }

    public void setQueryEngine(IQueryEngine qe) {
        this.setCell("__queryengine__", new Cell(qe));
    }

    public void setTarget(IRDFContainer rdfc) {
        this.setCell("__target__", new Cell(rdfc));
    }

    public void setSource(IRDFContainer rdfc) {
        this.setCell("__source__", new Cell(rdfc));
    }

    public void setInstructionSource(IRDFContainer rdfc) {
        this.setCell("__instructionsource__", new Cell(rdfc));
    }

    public void setInput(BufferedReader input) {
        this.setCell("__input__", new Cell(input));
    }

    public void setOutput(PrintWriter output) {
        this.setCell("__output__", new Cell(output));
    }

    public void setServiceAccessor(IServiceAccessor sa) {
        this.setCell("__serviceaccessor__", new Cell(sa));
    }

    public void setIdentity(Identity id) {
        this.setCell("__identity__", new Cell(id));
    }

    public void setMessage(Message msg) {
        this.setCell("__message__", new Cell(msg));
    }

    public void setMessageIfAny(Message msg) {
        if (msg != null) {
            this.setMessage(msg);
        }
    }
}

