/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.interpreter;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.instructions.ReturnException;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.ICallable;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.rdf.DAMLListIterator;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.ArrayList;
import java.util.Iterator;

public class Closure
implements ICallable {
    Environment m_env;
    Resource m_resBody;
    IExpression m_body = null;
    ArrayList m_parameters = new ArrayList();
    Interpreter m_interpreter;

    public Closure(Environment env, Resource resBody, Resource resParameters, Interpreter i) {
        this.m_env = (Environment)env.clone();
        this.m_resBody = resBody;
        this.m_interpreter = i;
        IRDFContainer source = i.getRootRDFContainer();
        DAMLListIterator j = ListUtilities.accessDAMLList(resParameters, source);
        while (j.hasNext()) {
            Resource resVarName = (Resource)j.next();
            String varName = Utilities.getLiteralProperty(resVarName, AdenineConstants.name, source);
            this.m_parameters.add(varName);
        }
    }

    public Closure(Environment env, IExpression body, Resource resParameters, Interpreter i) {
        this.m_env = (Environment)env.clone();
        this.m_body = body;
        this.m_interpreter = i;
        IRDFContainer source = i.getRootRDFContainer();
        DAMLListIterator j = ListUtilities.accessDAMLList(resParameters, source);
        while (j.hasNext()) {
            Resource resVarName = (Resource)j.next();
            String varName = Utilities.getLiteralProperty(resVarName, AdenineConstants.name, source);
            this.m_parameters.add(varName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {
        Environment env = (Environment)this.m_env.clone();
        int j = 0;
        Iterator i = this.m_parameters.iterator();
        Object[] parameters = message.m_values;
        while (i.hasNext()) {
            String varName = (String)i.next();
            env.allocateCell(varName);
            if (j < parameters.length) {
                env.setValue(varName, parameters[j]);
            } else {
                env.setValue(varName, null);
            }
            ++j;
        }
        parameters.getClass();
        Message o = denv.getMessageIfAny();
        denv.setMessage(message);
        try {
            Object ret;
            try {
                ret = this.m_body != null ? this.m_body.evaluate(env, denv) : this.m_interpreter.runInstruction(this.m_resBody, env, denv);
            }
            catch (ReturnException re) {
                Message message2 = re.m_retVal;
                Object var10_11 = null;
                denv.setMessageIfAny(o);
                return message2;
            }
            Object var10_13 = null;
            denv.setMessageIfAny(o);
            return new Message(ret);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            denv.setMessageIfAny(o);
            throw throwable;
        }
    }
}

