/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;

public class WithInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Object object;
        String var;
        block7: {
            Resource resLHS = Utilities.getResourceProperty(res, AdenineConstants.LHS, this.m_source);
            Resource resRHS = Utilities.getResourceProperty(res, AdenineConstants.RHS, this.m_source);
            Resource resBody = Utilities.getResourceProperty(res, AdenineConstants.body, this.m_source);
            if (!Utilities.isType(resLHS, AdenineConstants.Identifier, this.m_source)) throw new AdenineException("Invalid l-value in with statement", Interpreter.getLineNumber(res, this.m_source));
            Object old = null;
            boolean wasBound = false;
            var = null;
            try {
                try {
                    Object o = this.m_interpreter.runInstruction(resRHS, env, denv);
                    var = Utilities.getLiteralProperty(resLHS, AdenineConstants.name, this.m_source);
                    if (denv.isBound(var)) {
                        old = denv.getValue(var);
                        wasBound = true;
                    }
                    denv.setValue(var, o);
                    Environment env2 = (Environment)env.clone();
                    object = this.m_interpreter.runInstruction(resBody, env2, denv);
                    Object var12_15 = null;
                    if (var == null) return object;
                    if (!wasBound) break block7;
                }
                catch (AdenineException ae) {
                    ae.addToStackTrace("with", Interpreter.getLineNumber(res, this.m_source));
                    throw ae;
                }
                catch (NullPointerException npe) {
                    throw new AdenineException("Null pointer exception", npe, Interpreter.getLineNumber(res, this.m_source));
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                if (var == null) throw throwable;
                if (wasBound) {
                    denv.setValue(var, old);
                    throw throwable;
                }
                denv.unbind(var);
                throw throwable;
            }
            denv.setValue(var, old);
            return object;
        }
        denv.unbind(var);
        return object;
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            IExpression m_body;
            IExpression m_rhs;
            String m_var;
            int m_line;

            IExpression init(Resource res2) throws AdenineException {
                Resource resBody = Utilities.getResourceProperty(res2, AdenineConstants.body, WithInstruction.this.m_source);
                this.m_body = WithInstruction.this.m_interpreter.compileInstruction(resBody);
                this.m_line = Interpreter.getLineNumber(res2, WithInstruction.this.m_source);
                Resource resLHS = Utilities.getResourceProperty(res2, AdenineConstants.LHS, WithInstruction.this.m_source);
                Resource resRHS = Utilities.getResourceProperty(res2, AdenineConstants.RHS, WithInstruction.this.m_source);
                if (!Utilities.isType(resLHS, AdenineConstants.Identifier, WithInstruction.this.m_source)) {
                    throw new AdenineException("Invalid l-value in with statement", this.m_line);
                }
                this.m_rhs = WithInstruction.this.m_interpreter.compileInstruction(resRHS);
                this.m_var = Utilities.getLiteralProperty(resLHS, AdenineConstants.name, WithInstruction.this.m_source);
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                String ident = Interpreter.generateIdentifier();
                String ident2 = Interpreter.generateIdentifier();
                String ident3 = Interpreter.generateIdentifier();
                buffer.append("boolean ");
                buffer.append(ident);
                buffer.append(" = __dynamicenvironment__.isBound(\"");
                buffer.append(this.m_var);
                buffer.append("\");\n");
                buffer.append("Object ");
                buffer.append(ident2);
                buffer.append(" = ");
                buffer.append(ident);
                buffer.append(" ? __dynamicenvironment__.getValue(\"");
                buffer.append(this.m_var);
                buffer.append("\") : null;\n");
                buffer.append("Object ");
                buffer.append(ident3);
                buffer.append(" = null;\n");
                this.m_rhs.generateJava(ident3, buffer, frame, ct);
                buffer.append("__dynamicenvironment__.setValue(\"");
                buffer.append(this.m_var);
                buffer.append("\", ");
                buffer.append(ident3);
                buffer.append(");\n");
                buffer.append("try {\n");
                Interpreter.generateJavaBlock(this.m_body, buffer, frame, ct);
                buffer.append("} finally {\n");
                buffer.append("if (");
                buffer.append(ident);
                buffer.append(") {\n");
                buffer.append("__dynamicenvironment__.setValue(\"");
                buffer.append(this.m_var);
                buffer.append("\", ");
                buffer.append(ident2);
                buffer.append(");\n");
                buffer.append("}\n");
                buffer.append("}\n");
                buffer.append(targetVar);
                buffer.append(" = null;\n");
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Object object;
                block7: {
                    Object old = null;
                    boolean wasBound = false;
                    try {
                        try {
                            Object o = this.m_rhs.evaluate(env, denv);
                            if (denv.isBound(this.m_var)) {
                                old = denv.getValue(this.m_var);
                                wasBound = true;
                            }
                            denv.setValue(this.m_var, o);
                            object = this.m_body.evaluate(env, denv);
                            Object var6_9 = null;
                            if (!wasBound) break block7;
                        }
                        catch (AdenineException ae) {
                            ae.addToStackTrace("with", this.m_line);
                            throw ae;
                        }
                        catch (NullPointerException npe) {
                            throw new AdenineException("Null pointer exception", npe, this.m_line);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        if (wasBound) {
                            denv.setValue(this.m_var, old);
                            throw throwable;
                        }
                        denv.unbind(this.m_var);
                        throw throwable;
                    }
                    denv.setValue(this.m_var, old);
                    return object;
                }
                denv.unbind(this.m_var);
                return object;
            }
        }.init(res);
    }
}

