/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.instructions.BreakException;
import edu.mit.lcs.haystack.adenine.instructions.ContinueException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;

public class WhileInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resCondition = Utilities.getResourceProperty(res, AdenineConstants.CONDITION, this.m_source);
        Resource resBody = Utilities.getResourceProperty(res, AdenineConstants.body, this.m_source);
        try {
            block9: {
                Object condition;
                block8: {
                    if (!true) break block8;
                    condition = this.m_interpreter.runInstruction(resCondition, env, denv);
                    if (condition == null) return null;
                    if (!Interpreter.isTrue(condition)) break block9;
                }
                do {
                    Environment env2 = (Environment)env.clone();
                    try {
                        this.m_interpreter.runInstruction(resBody, env2, denv);
                    }
                    catch (BreakException be) {
                        return null;
                    }
                    catch (ContinueException continueException) {
                        // empty catch block
                    }
                    condition = this.m_interpreter.runInstruction(resCondition, env, denv);
                    if (condition == null) return null;
                } while (Interpreter.isTrue(condition));
            }
            return null;
        }
        catch (AdenineException ae) {
            ae.addToStackTrace("while", Interpreter.getLineNumber(res, this.m_source));
            throw ae;
        }
        catch (NullPointerException npe) {
            throw new AdenineException("Null pointer exception", npe, Interpreter.getLineNumber(res, this.m_source));
        }
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            IExpression m_body;
            IExpression m_condition;
            int m_line;

            IExpression init(Resource res2) throws AdenineException {
                Resource resCondition = Utilities.getResourceProperty(res2, AdenineConstants.CONDITION, WhileInstruction.this.m_source);
                Resource resBody = Utilities.getResourceProperty(res2, AdenineConstants.body, WhileInstruction.this.m_source);
                this.m_body = WhileInstruction.this.m_interpreter.compileInstruction(resBody);
                this.m_condition = WhileInstruction.this.m_interpreter.compileInstruction(resCondition);
                this.m_line = Interpreter.getLineNumber(res2, WhileInstruction.this.m_source);
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                buffer.append("while (true) {\n");
                this.m_condition.generateJava(targetVar, buffer, frame, ct);
                buffer.append("if (!Interpreter.isTrue(");
                buffer.append(targetVar);
                buffer.append(")) {\nbreak;\n}\n");
                Interpreter.generateJavaBlock(this.m_body, buffer, frame, ct);
                buffer.append("}\n");
                buffer.append(targetVar);
                buffer.append(" = null;\n");
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                try {
                    block9: {
                        Object condition;
                        block8: {
                            if (!true) break block8;
                            condition = this.m_condition.evaluate(env, denv);
                            if (condition == null) return null;
                            if (!Interpreter.isTrue(condition)) break block9;
                        }
                        do {
                            Environment env2 = (Environment)env.clone();
                            try {
                                this.m_body.evaluate(env2, denv);
                            }
                            catch (BreakException be) {
                                return null;
                            }
                            catch (ContinueException continueException) {
                                // empty catch block
                            }
                            condition = this.m_condition.evaluate(env, denv);
                            if (condition == null) return null;
                        } while (Interpreter.isTrue(condition));
                    }
                    return null;
                }
                catch (AdenineException ae) {
                    ae.addToStackTrace("while", this.m_line);
                    throw ae;
                }
                catch (NullPointerException npe) {
                    throw new AdenineException("Null pointer exception", npe, this.m_line);
                }
            }
        }.init(res);
    }
}

