/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.adenine.query.Condition;
import edu.mit.lcs.haystack.adenine.query.ConditionSet;
import edu.mit.lcs.haystack.rdf.DAMLListIterator;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.ArrayList;
import java.util.Iterator;

public class QueryInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        ConditionSet cs = new ConditionSet();
        DAMLListIterator i = ListUtilities.accessDAMLList(Utilities.getResourceProperty(res, AdenineConstants.queryConditions, this.m_source), this.m_source);
        while (i.hasNext()) {
            Resource resCondition = (Resource)i.next();
            Resource resFunction = null;
            ArrayList<Object> parameters = new ArrayList<Object>();
            DAMLListIterator i2 = ListUtilities.accessDAMLList(resCondition, this.m_interpreter.getRootRDFContainer());
            while (i2.hasNext()) {
                Object o = this.m_interpreter.runInstruction((Resource)i2.next(), env, denv);
                if (resFunction == null) {
                    resFunction = (Resource)o;
                    continue;
                }
                parameters.add(o);
            }
            cs.add(new Condition(resFunction, parameters));
        }
        return cs;
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            ArrayList m_al = new ArrayList();
            int m_line = -1;

            IExpression init(Resource res2) throws AdenineException {
                String strLine = Utilities.getLiteralProperty(res2, AdenineConstants.line, QueryInstruction.this.m_source);
                if (strLine != null) {
                    try {
                        this.m_line = Integer.parseInt(strLine);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                DAMLListIterator i = ListUtilities.accessDAMLList(Utilities.getResourceProperty(res2, AdenineConstants.queryConditions, QueryInstruction.this.m_source), QueryInstruction.this.m_source);
                while (i.hasNext()) {
                    Resource resCondition = (Resource)i.next();
                    IExpression function = null;
                    ArrayList<IExpression> parameters = new ArrayList<IExpression>();
                    DAMLListIterator i2 = ListUtilities.accessDAMLList(resCondition, QueryInstruction.this.m_interpreter.getRootRDFContainer());
                    while (i2.hasNext()) {
                        IExpression exp = QueryInstruction.this.m_interpreter.compileInstruction((Resource)i2.next());
                        if (function == null) {
                            function = exp;
                            continue;
                        }
                        parameters.add(exp);
                    }
                    this.m_al.add(new Object[]{function, parameters});
                }
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                throw new UnsupportedOperationException("%{} not supported with precompilation");
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                try {
                    Iterator i = this.m_al.iterator();
                    ConditionSet cs = new ConditionSet();
                    while (i.hasNext()) {
                        Object[] pair = (Object[])i.next();
                        Resource function = (Resource)((IExpression)pair[0]).evaluate(env, denv);
                        Iterator i2 = ((ArrayList)pair[1]).iterator();
                        ArrayList<Object> parameters = new ArrayList<Object>();
                        while (i2.hasNext()) {
                            parameters.add(((IExpression)i2.next()).evaluate(env, denv));
                        }
                        cs.add(new Condition(function, parameters));
                    }
                    return cs;
                }
                catch (ClassCastException cce) {
                    throw new AdenineException("Type error", cce, this.m_line);
                }
            }
        }.init(res);
    }
}

