/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.ISerializable;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.LocalRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ModelInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public static RDFNode extractNode(Object o, IRDFContainer rdfc) throws AdenineException, RDFException {
        try {
            if (o instanceof Collection) {
                return ListUtilities.createDAMLList(((Collection)o).iterator(), rdfc);
            }
            if (o instanceof RDFNode) {
                return (RDFNode)o;
            }
            if (o instanceof String) {
                return new Literal((String)o);
            }
            if (o == null) {
                return new Literal("null");
            }
            if (o instanceof ISerializable) {
                return ((ISerializable)o).serialize(rdfc);
            }
            return new Literal(o.toString());
        }
        catch (ClassCastException cce) {
            throw new AdenineException("Type error", cce);
        }
    }

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        denv = (DynamicEnvironment)denv.clone();
        LocalRDFContainer rdfc = new LocalRDFContainer();
        denv.setTarget(rdfc);
        RDFNode subject = null;
        RDFNode predicate = null;
        try {
            Resource[] statements = Utilities.getResourceProperties(res, AdenineConstants.statement, this.m_source);
            int i = 0;
            while (i < statements.length) {
                Resource resStatement = statements[i];
                subject = ModelInstruction.extractNode(this.m_interpreter.runInstruction((Resource)this.m_source.extract(resStatement, AdenineConstants.subject, null), env, denv), rdfc);
                predicate = ModelInstruction.extractNode(this.m_interpreter.runInstruction((Resource)this.m_source.extract(resStatement, AdenineConstants.predicate, null), env, denv), rdfc);
                Resource resSubject = (Resource)subject;
                Resource resPredicate = (Resource)predicate;
                rdfc.add(new Statement(resSubject, resPredicate, ModelInstruction.extractNode(this.m_interpreter.runInstruction((Resource)this.m_source.extract(resStatement, AdenineConstants.object, null), env, denv), rdfc)));
                ++i;
            }
        }
        catch (RDFException rdfe) {
            throw new AdenineException("Unknown error", rdfe);
        }
        catch (ClassCastException cce) {
            if (!(subject instanceof Resource)) {
                throw new AdenineException("Subject in model is not of type resource: " + subject);
            }
            if (!(predicate instanceof Resource)) {
                throw new AdenineException("Predicate in model is not of type resource: " + predicate);
            }
            throw new AdenineException("Unknown error", cce);
        }
        return rdfc;
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            ArrayList m_al = new ArrayList();
            int m_line = -1;
            Resource m_res;

            IExpression init(Resource res2) throws AdenineException {
                this.m_res = res2;
                String strLine = Utilities.getLiteralProperty(res2, AdenineConstants.line, ModelInstruction.this.m_source);
                if (strLine != null) {
                    try {
                        this.m_line = Integer.parseInt(strLine);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Resource[] statements = Utilities.getResourceProperties(res2, AdenineConstants.statement, ModelInstruction.this.m_source);
                int i = 0;
                while (i < statements.length) {
                    Resource r = statements[i];
                    IExpression subj = ModelInstruction.this.m_interpreter.compileInstruction(Utilities.getResourceProperty(r, AdenineConstants.subject, ModelInstruction.this.m_source));
                    IExpression pred = ModelInstruction.this.m_interpreter.compileInstruction(Utilities.getResourceProperty(r, AdenineConstants.predicate, ModelInstruction.this.m_source));
                    IExpression obj = ModelInstruction.this.m_interpreter.compileInstruction(Utilities.getResourceProperty(r, AdenineConstants.object, ModelInstruction.this.m_source));
                    this.m_al.add(new IExpression[]{subj, pred, obj});
                    ++i;
                }
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                buffer.append(targetVar);
                buffer.append(" = new LocalRDFContainer();\n");
                String ident0 = Interpreter.generateIdentifier();
                String ident1 = Interpreter.generateIdentifier();
                String ident2 = Interpreter.generateIdentifier();
                buffer.append("Object ");
                buffer.append(ident0);
                buffer.append(", ");
                buffer.append(ident1);
                buffer.append(", ");
                buffer.append(ident2);
                buffer.append(";\n");
                Iterator i = this.m_al.iterator();
                while (i.hasNext()) {
                    IExpression[] pair = (IExpression[])i.next();
                    pair[0].generateJava(ident0, buffer, frame, ct);
                    pair[1].generateJava(ident1, buffer, frame, ct);
                    pair[2].generateJava(ident2, buffer, frame, ct);
                    buffer.append("((IRDFContainer)");
                    buffer.append(targetVar);
                    buffer.append(").add(new Statement(");
                    buffer.append("(Resource)ModelInstruction.extractNode(");
                    buffer.append(ident0);
                    buffer.append(",__dynamicenvironment__.getTarget()),\n(Resource)ModelInstruction.extractNode(");
                    buffer.append(ident1);
                    buffer.append(",__dynamicenvironment__.getTarget()),\nModelInstruction.extractNode(");
                    buffer.append(ident2);
                    buffer.append(",__dynamicenvironment__.getTarget())));");
                }
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                denv = (DynamicEnvironment)denv.clone();
                LocalRDFContainer rdfc = new LocalRDFContainer();
                denv.setTarget(rdfc);
                try {
                    Iterator i = this.m_al.iterator();
                    while (i.hasNext()) {
                        IExpression[] pair = (IExpression[])i.next();
                        Object subj = pair[0].evaluate(env, denv);
                        Object pred = pair[1].evaluate(env, denv);
                        Object obj = pair[2].evaluate(env, denv);
                        rdfc.add(new Statement((Resource)ModelInstruction.extractNode(subj, rdfc), (Resource)ModelInstruction.extractNode(pred, rdfc), ModelInstruction.extractNode(obj, rdfc)));
                    }
                    return rdfc;
                }
                catch (RDFException rdfe) {
                    throw new AdenineException("Unknown error", rdfe, this.m_line);
                }
                catch (ClassCastException cce) {
                    throw new AdenineException("Type error " + this.m_res, cce, this.m_line);
                }
            }
        }.init(res);
    }
}

