/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.DAMLListIterator;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.ArrayList;
import java.util.Date;

public class MethodInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    static Resource duplicateParameterList(Resource list, IRDFContainer source, IRDFContainer target) throws RDFException {
        ArrayList<Resource> newParams = new ArrayList<Resource>();
        DAMLListIterator i = ListUtilities.accessDAMLList(list, source);
        while (i.hasNext()) {
            Resource param = (Resource)i.next();
            Resource newParam = Utilities.generateUniqueResource();
            target.add(new Statement(newParam, Constants.s_rdf_type, AdenineConstants.Identifier));
            target.add(new Statement(newParam, AdenineConstants.name, Utilities.getProperty(param, AdenineConstants.name, source)));
            newParams.add(newParam);
        }
        return ListUtilities.createDAMLList(newParams.iterator(), target);
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resStart = Utilities.getResourceProperty(res, AdenineConstants.start, this.m_source);
        Resource resParameters = Utilities.getResourceProperty(res, AdenineConstants.PARAMETERS, this.m_source);
        Resource name = Utilities.getResourceProperty(res, AdenineConstants.name, this.m_source);
        Resource resName = name == null ? Utilities.generateUniqueResource() : (Resource)this.m_interpreter.runInstruction(name, env, denv);
        try {
            IRDFContainer target = denv.getTarget();
            resParameters = MethodInstruction.duplicateParameterList(resParameters, this.m_source, target);
            target.add(new Statement(resName, Constants.s_rdf_type, AdenineConstants.Method));
            target.add(new Statement(resName, AdenineConstants.start, (Resource)this.m_interpreter.runInstruction(resStart, env, denv)));
            target.add(new Statement(resName, AdenineConstants.PARAMETERS, resParameters));
            target.add(new Statement(resName, AdenineConstants.compileTime, new Literal(new Date().toString())));
            Resource[] namedParameters = Utilities.getResourceProperties(res, AdenineConstants.namedParameter, this.m_source);
            int j = 0;
            while (j < namedParameters.length) {
                target.add(new Statement(resName, AdenineConstants.namedParameter, namedParameters[j]));
                ++j;
            }
        }
        catch (RDFException rdfe) {
            throw new AdenineException("RDF error", rdfe);
        }
        RDFNode varName = Utilities.getIndirectProperty(res, AdenineConstants.var, AdenineConstants.name, this.m_source);
        if (varName != null && varName instanceof Literal) {
            env.setValue(varName.getContent(), resName);
        }
        return resName;
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            IExpression m_name;
            IExpression m_start;
            String m_varName;
            Resource m_resParameters;
            Resource[] m_namedParameters;

            IExpression init(Resource res2) throws AdenineException {
                this.m_resParameters = Utilities.getResourceProperty(res2, AdenineConstants.PARAMETERS, MethodInstruction.this.m_source);
                Resource resStart = Utilities.getResourceProperty(res2, AdenineConstants.start, MethodInstruction.this.m_source);
                this.m_namedParameters = Utilities.getResourceProperties(res2, AdenineConstants.namedParameter, MethodInstruction.this.m_source);
                Resource name = Utilities.getResourceProperty(res2, AdenineConstants.name, MethodInstruction.this.m_source);
                this.m_name = name == null ? null : MethodInstruction.this.m_interpreter.compileInstruction(name);
                this.m_start = MethodInstruction.this.m_interpreter.compileInstruction(resStart);
                RDFNode varName = Utilities.getIndirectProperty(res2, AdenineConstants.var, AdenineConstants.name, MethodInstruction.this.m_source);
                this.m_varName = varName != null && varName instanceof Literal ? varName.getContent() : null;
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                if (this.m_name != null) {
                    this.m_name.generateJava(targetVar, buffer, frame, ct);
                } else {
                    buffer.append(targetVar);
                    buffer.append(" = ");
                    buffer.append("Utilities.generateUniqueResource();\n");
                }
                String ident0 = Interpreter.generateIdentifier();
                String ident1 = Interpreter.generateIdentifier();
                String ident2 = Interpreter.generateIdentifier();
                buffer.append("Object ");
                buffer.append(ident0);
                buffer.append(";\n");
                buffer.append("__dynamicenvironment__.getTarget().add(new Statement((Resource)");
                buffer.append(targetVar);
                buffer.append(", Constants.s_rdf_type, AdenineConstants.Method));\n");
                this.m_start.generateJava(ident0, buffer, frame, ct);
                buffer.append("__dynamicenvironment__.getTarget().add(new Statement((Resource)");
                buffer.append(targetVar);
                buffer.append(", AdenineConstants.start, (Resource) ");
                buffer.append(ident0);
                buffer.append("));\n");
                buffer.append("__dynamicenvironment__.getTarget().add(new Statement((Resource)");
                buffer.append(targetVar);
                buffer.append(", AdenineConstants.compileTime, new Literal(new Date().toString())));\n");
                buffer.append("Resource ");
                buffer.append(ident2);
                buffer.append(";\nArrayList ");
                buffer.append(ident1);
                buffer.append(" = new ArrayList();\n");
                DAMLListIterator i = ListUtilities.accessDAMLList(this.m_resParameters, MethodInstruction.this.m_source);
                while (i.hasNext()) {
                    Resource param = (Resource)i.next();
                    buffer.append(ident2);
                    buffer.append(" = Utilities.generateUniqueResource();\n");
                    buffer.append("__dynamicenvironment__.getTarget().add(new Statement(");
                    buffer.append(ident2);
                    buffer.append(", Constants.s_rdf_type, AdenineConstants.Identifier));\n");
                    buffer.append("__dynamicenvironment__.getTarget().add(new Statement(");
                    buffer.append(ident2);
                    buffer.append(", AdenineConstants.name, (Literal)");
                    buffer.append(ct.getConstantName("new Literal(\"" + Interpreter.escapeString(Utilities.getLiteralProperty(param, AdenineConstants.name, MethodInstruction.this.m_source)) + "\")"));
                    buffer.append("));\n");
                    buffer.append(ident1);
                    buffer.append(".add(");
                    buffer.append(ident2);
                    buffer.append(");\n");
                }
                buffer.append("__dynamicenvironment__.getTarget().add(new Statement((Resource)");
                buffer.append(targetVar);
                buffer.append(", AdenineConstants.PARAMETERS, ListUtilities.createDAMLList(");
                buffer.append(ident1);
                buffer.append(".iterator(), __dynamicenvironment__.getTarget())));\n");
                int j = 0;
                while (j < this.m_namedParameters.length) {
                    buffer.append("__dynamicenvironment__.getTarget().add(new Statement((Resource)");
                    buffer.append(targetVar);
                    buffer.append(", AdenineConstants.namedParameter, ");
                    buffer.append(ct.getConstantName("new Resource(\"" + Interpreter.escapeString(this.m_namedParameters[j].getURI()) + "\")"));
                    buffer.append("));\n");
                    ++j;
                }
                if (this.m_varName != null) {
                    buffer.append(frame.generateVariableName(this.m_varName));
                    buffer.append(" = ");
                    buffer.append(targetVar);
                    buffer.append(";\n");
                }
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Resource resName = this.m_name == null ? Utilities.generateUniqueResource() : (Resource)this.m_name.evaluate(env, denv);
                IRDFContainer target = denv.getTarget();
                try {
                    target.add(new Statement(resName, Constants.s_rdf_type, AdenineConstants.Method));
                    target.add(new Statement(resName, AdenineConstants.start, (Resource)this.m_start.evaluate(env, denv)));
                    target.add(new Statement(resName, AdenineConstants.PARAMETERS, MethodInstruction.duplicateParameterList(this.m_resParameters, MethodInstruction.this.m_source, denv.getTarget())));
                    target.add(new Statement(resName, AdenineConstants.compileTime, new Literal(new Date().toString())));
                    int j = 0;
                    while (j < this.m_namedParameters.length) {
                        target.add(new Statement(resName, AdenineConstants.namedParameter, this.m_namedParameters[j]));
                        ++j;
                    }
                }
                catch (RDFException rdfe) {
                    throw new AdenineException("RDF error", rdfe);
                }
                if (this.m_varName != null) {
                    env.setValue(this.m_varName, resName);
                }
                return resName;
            }
        }.init(res);
    }
}

