/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.DAMLListIterator;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Method2Instruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    static Resource duplicateParameterList(Resource list, IRDFContainer source, IRDFContainer target) throws RDFException {
        ArrayList<Resource> newParams = new ArrayList<Resource>();
        DAMLListIterator i = ListUtilities.accessDAMLList(list, source);
        while (i.hasNext()) {
            Resource param = (Resource)i.next();
            Resource newParam = Utilities.generateUniqueResource();
            target.add(new Statement(newParam, Constants.s_rdf_type, AdenineConstants.Identifier));
            target.add(new Statement(newParam, AdenineConstants.name, Utilities.getProperty(param, AdenineConstants.name, source)));
            newParams.add(newParam);
        }
        return ListUtilities.createDAMLList(newParams.iterator(), target);
    }

    public Object evaluate(Resource instruction, Environment env, DynamicEnvironment denv) throws AdenineException {
        IExpression e = this.generateExpression(instruction);
        return e.evaluate(env, denv);
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            Resource m_instruction;
            Literal m_varName;
            List m_parameters;
            List m_backquotedParameters;
            Resource m_wrappedMethod;

            IExpression init(Resource instruction) throws AdenineException {
                this.m_instruction = instruction;
                this.m_wrappedMethod = Utilities.getResourceProperty(this.m_instruction, AdenineConstants.function, Method2Instruction.this.m_source);
                Resource resParameters = Utilities.getResourceProperty(this.m_wrappedMethod, AdenineConstants.PARAMETERS, Method2Instruction.this.m_source);
                Resource resBackquotedParameters = Utilities.getResourceProperty(this.m_instruction, AdenineConstants.BACKQUOTED_PARAMETERS, Method2Instruction.this.m_source);
                DAMLListIterator iParameters = ListUtilities.accessDAMLList(resParameters, Method2Instruction.this.m_source);
                DAMLListIterator iBackquotedParameters = ListUtilities.accessDAMLList(resBackquotedParameters, Method2Instruction.this.m_source);
                this.m_parameters = new ArrayList();
                while (iParameters.hasNext()) {
                    this.m_parameters.add(iParameters.next());
                }
                this.m_backquotedParameters = new ArrayList();
                while (iBackquotedParameters.hasNext()) {
                    this.m_backquotedParameters.add(iBackquotedParameters.next());
                }
                this.m_varName = (Literal)Utilities.getIndirectProperty(this.m_instruction, AdenineConstants.var, AdenineConstants.name, Method2Instruction.this.m_source);
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Resource method = this.m_wrappedMethod;
                Iterator iParameters = this.m_parameters.iterator();
                Iterator iBackquotedParameters = this.m_backquotedParameters.iterator();
                if (iBackquotedParameters.hasNext()) {
                    try {
                        RDFNode parameter;
                        IRDFContainer target = denv.getTarget();
                        LinkedList<RDFNode> arguments = new LinkedList<RDFNode>();
                        LinkedList<RDFNode> parameters = new LinkedList<RDFNode>();
                        while (iBackquotedParameters.hasNext()) {
                            Resource r;
                            parameter = (Literal)iBackquotedParameters.next();
                            iParameters.next();
                            Object value = env.getValue(parameter.getContent());
                            if (value instanceof Resource) {
                                r = Utilities.generateUniqueResource();
                                target.add(new Statement(r, Constants.s_rdf_type, AdenineConstants.Resource));
                                target.add(new Statement(r, AdenineConstants.resource, (Resource)value));
                                arguments.add(r);
                                continue;
                            }
                            if (value instanceof Literal) {
                                r = Utilities.generateUniqueResource();
                                target.add(new Statement(r, Constants.s_rdf_type, AdenineConstants.Literal));
                                target.add(new Statement(r, AdenineConstants.literal, (Literal)value));
                                arguments.add(r);
                                continue;
                            }
                            if (value instanceof String) {
                                r = Utilities.generateUniqueResource();
                                target.add(new Statement(r, Constants.s_rdf_type, AdenineConstants.Literal));
                                target.add(new Statement(r, AdenineConstants.literal, new Literal((String)value)));
                                arguments.add(r);
                                continue;
                            }
                            if (value instanceof Integer || value instanceof Float) {
                                r = Utilities.generateUniqueResource();
                                target.add(new Statement(r, Constants.s_rdf_type, AdenineConstants.Identifier));
                                target.add(new Statement(r, AdenineConstants.name, new Literal(value.toString())));
                                arguments.add(r);
                                continue;
                            }
                            r = Utilities.generateUniqueResource();
                            target.add(new Statement(r, Constants.s_rdf_type, AdenineConstants.Literal));
                            target.add(new Statement(r, AdenineConstants.literal, new Literal(value.toString())));
                            arguments.add(r);
                        }
                        while (iParameters.hasNext()) {
                            parameter = (Resource)iParameters.next();
                            parameters.add(parameter);
                            arguments.add(parameter);
                        }
                        method = Utilities.generateUniqueResource();
                        Resource callReturnInstruction = Utilities.generateUniqueResource();
                        target.add(new Statement(callReturnInstruction, Constants.s_rdf_type, AdenineConstants.CallReturn));
                        Resource resourceInstruction = Utilities.generateUniqueResource();
                        target.add(new Statement(resourceInstruction, Constants.s_rdf_type, AdenineConstants.Resource));
                        target.add(new Statement(resourceInstruction, AdenineConstants.resource, this.m_wrappedMethod));
                        target.add(new Statement(callReturnInstruction, AdenineConstants.function, resourceInstruction));
                        target.add(new Statement(method, Constants.s_rdf_type, AdenineConstants.Method));
                        target.add(new Statement(method, AdenineConstants.start, callReturnInstruction));
                        Resource[] namedParameters = Utilities.getResourceProperties(this.m_wrappedMethod, AdenineConstants.namedParameter, Method2Instruction.this.m_source);
                        int j = 0;
                        while (j < namedParameters.length) {
                            Resource namedParameter = namedParameters[j];
                            target.add(new Statement(method, AdenineConstants.namedParameter, namedParameter));
                            target.add(new Statement(callReturnInstruction, AdenineConstants.namedParameter, namedParameter));
                            ++j;
                        }
                        target.add(new Statement(method, AdenineConstants.PARAMETERS, ListUtilities.createDAMLList(parameters.iterator(), Method2Instruction.this.m_source)));
                        target.add(new Statement(callReturnInstruction, AdenineConstants.PARAMETERS, ListUtilities.createDAMLList(arguments.iterator(), Method2Instruction.this.m_source)));
                    }
                    catch (RDFException rdfe) {
                        throw new AdenineException("RDF error", rdfe);
                    }
                }
                if (this.m_varName != null) {
                    env.setValue(this.m_varName.getContent(), method);
                }
                return method;
            }
        }.init(res);
    }
}

