/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;

public class IfInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resCondition = Utilities.getResourceProperty(res, AdenineConstants.CONDITION, this.m_source);
        Resource resBody = Utilities.getResourceProperty(res, AdenineConstants.body, this.m_source);
        Object condition = this.m_interpreter.runInstruction(resCondition, env, denv);
        if (Interpreter.isTrue(condition)) {
            Environment env2 = (Environment)env.clone();
            this.m_interpreter.runInstruction(resBody, env2, denv);
        } else {
            Resource resElseBody = Utilities.getResourceProperty(res, AdenineConstants.ELSEBODY, this.m_source);
            if (resElseBody != null) {
                Environment env2 = (Environment)env.clone();
                this.m_interpreter.runInstruction(resElseBody, env2, denv);
            }
        }
        return null;
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            IExpression m_condition;
            IExpression m_body;
            IExpression m_else = null;

            IExpression init(Resource res2) throws AdenineException {
                Resource resCondition = Utilities.getResourceProperty(res2, AdenineConstants.CONDITION, IfInstruction.this.m_source);
                Resource resBody = Utilities.getResourceProperty(res2, AdenineConstants.body, IfInstruction.this.m_source);
                this.m_condition = IfInstruction.this.m_interpreter.compileInstruction(resCondition);
                this.m_body = IfInstruction.this.m_interpreter.compileInstruction(resBody);
                Resource resElseBody = Utilities.getResourceProperty(res2, AdenineConstants.ELSEBODY, IfInstruction.this.m_source);
                if (resElseBody != null) {
                    this.m_else = IfInstruction.this.m_interpreter.compileInstruction(resElseBody);
                }
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                this.m_condition.generateJava(targetVar, buffer, frame, ct);
                buffer.append("if (Interpreter.isTrue(");
                buffer.append(targetVar);
                buffer.append(")) {\n");
                Interpreter.generateJavaBlock(this.m_body, buffer, frame, ct);
                buffer.append("}\n");
                if (this.m_else != null) {
                    buffer.append("else {\n");
                    Interpreter.generateJavaBlock(this.m_else, buffer, frame, ct);
                    buffer.append("}\n");
                }
                buffer.append(targetVar);
                buffer.append(" = null;\n");
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Object condition = this.m_condition.evaluate(env, denv);
                if (Interpreter.isTrue(condition)) {
                    Environment env2 = (Environment)env.clone();
                    this.m_body.evaluate(env2, denv);
                } else if (this.m_else != null) {
                    Environment env2 = (Environment)env.clone();
                    this.m_else.evaluate(env2, denv);
                }
                return null;
            }
        }.init(res);
    }
}

