/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.UnboundIdentifierException;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;

public class IdentifierInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        String str = Utilities.getLiteralProperty(res, AdenineConstants.name, this.m_source);
        try {
            if (str.indexOf(46) != -1) {
                return new Double(Double.parseDouble(str));
            }
            int i = Integer.parseInt(str);
            return new Integer(i);
        }
        catch (Exception exception) {
            if (!env.isBound(str)) {
                if (!denv.isBound(str)) {
                    throw new UnboundIdentifierException(str);
                }
                return denv.getValue(str);
            }
            return env.getValue(str);
        }
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            Integer m_integer = null;
            Double m_double = null;
            String m_str;

            IExpression init(Resource res2) {
                this.m_str = Utilities.getLiteralProperty(res2, AdenineConstants.name, IdentifierInstruction.this.m_source);
                try {
                    if (this.m_str.indexOf(46) != -1) {
                        this.m_double = new Double(Double.parseDouble(this.m_str));
                    } else {
                        int i = Integer.parseInt(this.m_str);
                        this.m_integer = new Integer(i);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                buffer.append(targetVar);
                buffer.append(" = ");
                if (this.m_integer != null) {
                    buffer.append(ct.getConstantName("new Integer(" + this.m_integer + ")"));
                } else if (this.m_double != null) {
                    buffer.append(ct.getConstantName("new Double(" + this.m_double + ")"));
                } else {
                    try {
                        buffer.append(frame.resolveVariableName(this.m_str));
                    }
                    catch (UnboundIdentifierException uie) {
                        buffer.append("__dynamicenvironment__.getValueChecked(\"");
                        buffer.append(this.m_str);
                        buffer.append("\")");
                    }
                }
                buffer.append(";\n");
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                if (this.m_integer != null) {
                    return this.m_integer;
                }
                if (this.m_double != null) {
                    return this.m_double;
                }
                if (!env.isBound(this.m_str)) {
                    if (!denv.isBound(this.m_str)) {
                        throw new UnboundIdentifierException(this.m_str);
                    }
                    return denv.getValue(this.m_str);
                }
                return env.getValue(this.m_str);
            }
        }.init(res);
    }
}

