/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.Closure;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.Iterator;

public class FunctionInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resFunction = Utilities.getResourceProperty(res, AdenineConstants.function, this.m_source);
        Resource resParameters = Utilities.getResourceProperty(res, AdenineConstants.PARAMETERS, this.m_source);
        Resource resBody = Utilities.getResourceProperty(res, AdenineConstants.body, this.m_source);
        String name = Utilities.getLiteralProperty(resFunction, AdenineConstants.name, this.m_source);
        env.allocateCell(name);
        Closure c = new Closure(env, resBody, resParameters, this.m_interpreter);
        env.setValue(name, c);
        return c;
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            String m_name;
            Resource m_resParameters;
            IExpression m_body;
            Resource m_res;

            IExpression init(Resource res2) throws AdenineException {
                Resource resFunction = Utilities.getResourceProperty(res2, AdenineConstants.function, FunctionInstruction.this.m_source);
                this.m_resParameters = Utilities.getResourceProperty(res2, AdenineConstants.PARAMETERS, FunctionInstruction.this.m_source);
                Resource resBody = Utilities.getResourceProperty(res2, AdenineConstants.body, FunctionInstruction.this.m_source);
                this.m_res = res2;
                this.m_body = FunctionInstruction.this.m_interpreter.compileInstruction(resBody);
                this.m_name = Utilities.getLiteralProperty(resFunction, AdenineConstants.name, FunctionInstruction.this.m_source);
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame0, ConstantTable ct) throws AdenineException {
                frame0.m_variables.add(this.m_name);
                Resource[] namedParameters = Utilities.getResourceProperties(this.m_res, AdenineConstants.namedParameter, FunctionInstruction.this.m_source);
                if (namedParameters.length > 0) {
                    throw new UnsupportedOperationException("Named parameters not supported with Adenine compilation.");
                }
                String denvvar = Interpreter.generateIdentifier();
                String ivar = Interpreter.generateIdentifier();
                buffer.append(frame0.resolveVariableName(this.m_name));
                buffer.append(" = new ICallable() {\n");
                buffer.append("public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {\n");
                buffer.append("DynamicEnvironment ");
                buffer.append(denvvar);
                buffer.append(" = __dynamicenvironment__;\n__dynamicenvironment__ = denv;\n");
                buffer.append("try {");
                buffer.append("int ");
                buffer.append(ivar);
                buffer.append(" = 0;\n");
                VariableFrame frame = new VariableFrame();
                frame.m_parentFrame = frame0;
                StringBuffer sb2 = new StringBuffer();
                Iterator i = ListUtilities.accessDAMLList(this.m_resParameters, FunctionInstruction.this.m_source);
                while (i.hasNext()) {
                    Resource resVarName = (Resource)i.next();
                    String varName = Utilities.getLiteralProperty(resVarName, AdenineConstants.name, FunctionInstruction.this.m_source);
                    frame.m_variables.add(varName);
                    buffer.append("if (");
                    buffer.append(ivar);
                    buffer.append(" < message.m_values.length) {\n");
                    buffer.append(frame.resolveVariableName(varName));
                    buffer.append(" = message.m_values[");
                    buffer.append(ivar);
                    buffer.append("++];\n}\n");
                    sb2.append("Object ");
                    sb2.append(frame.resolveVariableName(varName));
                    sb2.append(";\n");
                }
                buffer.append("\n");
                StringBuffer sb3 = new StringBuffer();
                String out = Interpreter.generateIdentifier();
                VariableFrame vf2 = Interpreter.generateJavaBlock(out, this.m_body, sb3, frame, null, ct, false);
                buffer.append("Object ");
                buffer.append(out);
                buffer.append(";\n");
                buffer.append(sb3);
                buffer.append("__dynamicenvironment__ = ");
                buffer.append(denvvar);
                buffer.append(";\n");
                buffer.append("return new Message(");
                buffer.append(out);
                buffer.append(");\n} catch (AdenineException ae) { throw ae; } catch (Exception e) { throw new AdenineException(\"\", e); } }\n");
                buffer.append(sb2);
                i = vf2.m_variables.iterator();
                while (i.hasNext()) {
                    String ident2 = (String)i.next();
                    buffer.append("Object ");
                    buffer.append(vf2.resolveVariableName(ident2));
                    buffer.append(" = null;\n");
                }
                buffer.append("};\n");
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                env.allocateCell(this.m_name);
                Closure c = new Closure(env, this.m_body, this.m_resParameters, FunctionInstruction.this.m_interpreter);
                env.setValue(this.m_name, c);
                return c;
            }
        }.init(res);
    }
}

