/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SyntaxException;
import edu.mit.lcs.haystack.adenine.functions.NewFunction;
import edu.mit.lcs.haystack.adenine.instructions.ResourceInstruction;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.ICallable;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.DAMLListIterator;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class FunctionCallInstruction
implements IInstructionHandler {
    protected IRDFContainer m_source;
    protected Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public static void compileParameters(Resource res2, Resource param, Resource namedParam, ArrayList m_parameters, ArrayList m_namedParameters, IRDFContainer m_source, Interpreter m_interpreter) throws AdenineException {
        Resource resParameters = Utilities.getResourceProperty(res2, param, m_source);
        DAMLListIterator i = ListUtilities.accessDAMLList(resParameters, m_source);
        while (i.hasNext()) {
            m_parameters.add(m_interpreter.compileInstruction((Resource)i.next()));
        }
        Resource[] namedParameters = Utilities.getResourceProperties(res2, namedParam, m_source);
        int j = 0;
        while (j < namedParameters.length) {
            Resource lhs = Utilities.getResourceProperty(namedParameters[j], AdenineConstants.parameterName, m_source);
            Resource rhs = Utilities.getResourceProperty(namedParameters[j], AdenineConstants.parameterVariable, m_source);
            m_namedParameters.add(new Object[]{lhs, m_interpreter.compileInstruction(rhs)});
            ++j;
        }
    }

    public static void getParameters(Resource res, Resource param, Resource namedParam, Vector v, HashMap namedParameterMap, IRDFContainer source, Interpreter interpreter, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resParameters = Utilities.getResourceProperty(res, param, source);
        DAMLListIterator i = ListUtilities.accessDAMLList(resParameters, source);
        while (i.hasNext()) {
            Object o2 = interpreter.runInstruction((Resource)i.next(), env, denv);
            v.add(o2);
        }
        Resource[] namedParameters = Utilities.getResourceProperties(res, namedParam, source);
        int j = 0;
        while (j < namedParameters.length) {
            Resource lhs = Utilities.getResourceProperty(namedParameters[j], AdenineConstants.parameterName, source);
            Resource rhs = Utilities.getResourceProperty(namedParameters[j], AdenineConstants.parameterVariable, source);
            namedParameterMap.put(lhs, interpreter.runInstruction(rhs, env, denv));
            ++j;
        }
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resFunction = Utilities.getResourceProperty(res, AdenineConstants.function, this.m_source);
        Object o = this.m_interpreter.runInstruction(resFunction, env, denv);
        if (!(o instanceof ICallable || o instanceof Class || o instanceof Resource)) {
            throw new SyntaxException("Object is not callable: " + o);
        }
        Vector<Object> v = new Vector<Object>();
        HashMap namedParameterMap = new HashMap();
        FunctionCallInstruction.getParameters(res, AdenineConstants.PARAMETERS, AdenineConstants.namedParameter, v, namedParameterMap, this.m_source, this.m_interpreter, env, denv);
        if (o instanceof Class) {
            v.insertElementAt(o, 0);
            return new NewFunction().invoke(new Message(v.toArray()), denv).getPrimaryValue();
        }
        Object out = o instanceof Resource ? this.m_interpreter.callMethod((Resource)o, new Message(v.toArray(), namedParameterMap), denv).getPrimaryValue() : ((ICallable)o).invoke(new Message(v.toArray(), namedParameterMap), denv).getPrimaryValue();
        return out;
    }

    public static final Message doFunctionCall(Object o, Object[] parameters, Map namedParams, DynamicEnvironment denv, Interpreter interpreter, int line) throws AdenineException {
        try {
            if (o instanceof Class) {
                Object[] params2 = new Object[parameters.length + 1];
                System.arraycopy(parameters, 0, params2, 1, parameters.length);
                params2[0] = o;
                return new NewFunction().invoke(new Message(params2, namedParams), denv);
            }
            if (o instanceof Resource) {
                return interpreter.callMethod((Resource)o, new Message(parameters, namedParams), denv);
            }
            if (o instanceof ICallable) {
                return ((ICallable)o).invoke(new Message(parameters, namedParams), denv);
            }
            AdenineException ae = new AdenineException("Object not callable; parameters: " + Arrays.asList(parameters));
            ae.m_line = line;
            throw ae;
        }
        catch (AdenineException ae) {
            ae.addToStackTrace("Function call", line);
            throw ae;
        }
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            IExpression m_function;
            int m_line;
            ArrayList m_parameters = new ArrayList();
            ArrayList m_namedParameters = new ArrayList();

            IExpression init(Resource res2) throws AdenineException {
                Resource resFunction = Utilities.getResourceProperty(res2, AdenineConstants.function, FunctionCallInstruction.this.m_source);
                this.m_line = Interpreter.getLineNumber(res2, FunctionCallInstruction.this.m_source);
                this.m_function = FunctionCallInstruction.this.m_interpreter.compileInstruction(resFunction);
                FunctionCallInstruction.compileParameters(res2, AdenineConstants.PARAMETERS, AdenineConstants.namedParameter, this.m_parameters, this.m_namedParameters, FunctionCallInstruction.this.m_source, FunctionCallInstruction.this.m_interpreter);
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                boolean hasNamedParameters = !this.m_namedParameters.isEmpty();
                String func = Interpreter.generateIdentifier();
                String vector = Interpreter.generateIdentifier();
                buffer.append("Object[] ");
                buffer.append(vector);
                buffer.append(" = new Object[");
                buffer.append(this.m_parameters.size());
                buffer.append("];\n");
                Iterator i = this.m_parameters.iterator();
                int i2 = 0;
                while (i.hasNext()) {
                    IExpression exp = (IExpression)i.next();
                    exp.generateJava(String.valueOf(vector) + "[" + i2++ + "]", buffer, frame, ct);
                }
                String map = null;
                if (hasNamedParameters) {
                    map = Interpreter.generateIdentifier();
                    String datum = Interpreter.generateIdentifier();
                    buffer.append("HashMap ");
                    buffer.append(map);
                    buffer.append(" = new HashMap();\nObject ");
                    buffer.append(datum);
                    buffer.append(" = null;\n");
                    i = this.m_namedParameters.iterator();
                    HashMap namedParameters = new HashMap();
                    while (i.hasNext()) {
                        Object[] pair = (Object[])i.next();
                        ((IExpression)pair[1]).generateJava(datum, buffer, frame, ct);
                        buffer.append(map);
                        buffer.append(".put(");
                        buffer.append(ct.getConstantName("new Resource(\"" + Interpreter.escapeString(((Resource)pair[0]).getURI()) + "\")"));
                        buffer.append(", ");
                        buffer.append(datum);
                        buffer.append(");\n");
                    }
                }
                if (this.m_function instanceof ResourceInstruction.ResourceExpression) {
                    buffer.append(targetVar);
                    buffer.append(" = __interpreter__.callMethod((Resource)");
                    buffer.append(ct.getConstantName("new Resource(\"" + Interpreter.escapeString(((ResourceInstruction.ResourceExpression)this.m_function).getResource().getURI()) + "\")"));
                    buffer.append(", new Message(");
                    buffer.append(vector);
                    if (hasNamedParameters) {
                        buffer.append(", ");
                        buffer.append(map);
                    }
                    buffer.append("), __dynamicenvironment__).getPrimaryValue();\n");
                } else {
                    buffer.append("Object ");
                    buffer.append(func);
                    buffer.append(";\n");
                    this.m_function.generateJava(func, buffer, frame, ct);
                    buffer.append(targetVar);
                    buffer.append(" = FunctionCallInstruction.doFunctionCall(");
                    buffer.append(func);
                    buffer.append(", ");
                    buffer.append(vector);
                    if (hasNamedParameters) {
                        buffer.append(", ");
                        buffer.append(map);
                    } else {
                        buffer.append(", null");
                    }
                    buffer.append(", __dynamicenvironment__, __interpreter__, ");
                    buffer.append(this.m_line);
                    buffer.append(").getPrimaryValue();\n");
                }
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Object o = this.m_function.evaluate(env, denv);
                Object[] parameters = new Object[this.m_parameters.size()];
                Iterator i = this.m_parameters.iterator();
                int i2 = 0;
                while (i.hasNext()) {
                    parameters[i2++] = ((IExpression)i.next()).evaluate(env, denv);
                }
                i = this.m_namedParameters.iterator();
                HashMap<Object, Object> namedParameters = new HashMap<Object, Object>();
                while (i.hasNext()) {
                    Object[] pair = (Object[])i.next();
                    namedParameters.put(pair[0], ((IExpression)pair[1]).evaluate(env, denv));
                }
                try {
                    return FunctionCallInstruction.doFunctionCall(o, parameters, namedParameters, denv, FunctionCallInstruction.this.m_interpreter, this.m_line).getPrimaryValue();
                }
                catch (AdenineException ae) {
                    throw ae;
                }
                catch (Exception e) {
                    throw new AdenineException("Function call error", e, this.m_line);
                }
            }
        }.init(res);
    }
}

