/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SyntaxException;
import edu.mit.lcs.haystack.adenine.functions.NewFunction;
import edu.mit.lcs.haystack.adenine.instructions.FunctionCallInstruction;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.ICallable;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.DAMLListIterator;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class CallInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public static Object mapMessageToIdentifiers(Message msg, Vector v, HashMap map, Environment env) {
        int c = v.size();
        int i = 0;
        while (i < c) {
            if (i < msg.m_values.length) {
                env.setValue((String)v.elementAt(i), msg.m_values[i]);
            } else {
                env.setValue((String)v.elementAt(i), null);
            }
            ++i;
        }
        Iterator j = map.keySet().iterator();
        while (j.hasNext()) {
            Resource res = (Resource)j.next();
            String name = (String)map.get(res);
            if (msg.m_namedValues != null && res != null && msg.m_namedValues.containsKey(res)) {
                env.setValue(name, msg.m_namedValues.get(res));
                continue;
            }
            env.setValue(name, null);
        }
        return c == 0 ? null : v.elementAt(0);
    }

    public static void getReturnParameters(Resource res, Vector v, HashMap namedParameterMap, IRDFContainer source, Interpreter interpreter, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resParameters = Utilities.getResourceProperty(res, AdenineConstants.RETURN_PARAMETERS, source);
        DAMLListIterator i = ListUtilities.accessDAMLList(resParameters, source);
        while (i.hasNext()) {
            String name = Utilities.getLiteralProperty((Resource)i.next(), AdenineConstants.name, source);
            v.add(name);
        }
        Resource[] namedParameters = Utilities.getResourceProperties(res, AdenineConstants.NAMED_RETURN_PARAMETER, source);
        int j = 0;
        while (j < namedParameters.length) {
            Resource lhs = Utilities.getResourceProperty(namedParameters[j], AdenineConstants.parameterName, source);
            Resource rhs = Utilities.getResourceProperty(namedParameters[j], AdenineConstants.parameterVariable, source);
            namedParameterMap.put(lhs, Utilities.getLiteralProperty(rhs, AdenineConstants.name, source));
            ++j;
        }
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Vector v2 = new Vector();
        HashMap namedParameterMap2 = new HashMap();
        CallInstruction.getReturnParameters(res, v2, namedParameterMap2, this.m_source, this.m_interpreter, env, denv);
        return CallInstruction.mapMessageToIdentifiers(this.internalEvaluate(res, env, denv), v2, namedParameterMap2, env);
    }

    protected Message internalEvaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resFunction = Utilities.getResourceProperty(res, AdenineConstants.function, this.m_source);
        Object o = this.m_interpreter.runInstruction(resFunction, env, denv);
        if (!(o instanceof ICallable || o instanceof Class || o instanceof Resource)) {
            throw new SyntaxException("Object is not callable: " + o);
        }
        Vector<Object> v = new Vector<Object>();
        HashMap namedParameterMap = new HashMap();
        FunctionCallInstruction.getParameters(res, AdenineConstants.PARAMETERS, AdenineConstants.namedParameter, v, namedParameterMap, this.m_source, this.m_interpreter, env, denv);
        if (o instanceof Class) {
            v.insertElementAt(o, 0);
            Message msg = new NewFunction().invoke(new Message(v.toArray()), denv);
            return msg;
        }
        Message out = o instanceof Resource ? this.m_interpreter.callMethod((Resource)o, new Message(v.toArray(), namedParameterMap), denv) : ((ICallable)o).invoke(new Message(v.toArray()), denv);
        return out;
    }

    public static Object doFunctionCall(Object o, Vector v, Map namedParams, Vector v2, HashMap namedParams2, DynamicEnvironment denv, Interpreter interpreter, int line, Environment env) throws AdenineException {
        try {
            if (o instanceof Class) {
                v.insertElementAt(o, 0);
                Message msg = new NewFunction().invoke(new Message(v.toArray(), namedParams), denv);
                return msg.getPrimaryValue();
            }
            if (o instanceof Resource) {
                Message msg = interpreter.callMethod((Resource)o, new Message(v.toArray(), namedParams), denv);
                return CallInstruction.mapMessageToIdentifiers(msg, v2, namedParams2, env);
            }
            if (o instanceof ICallable) {
                Message msg = ((ICallable)o).invoke(new Message(v.toArray(), namedParams), denv);
                return CallInstruction.mapMessageToIdentifiers(msg, v2, namedParams2, env);
            }
            AdenineException ae = new AdenineException("Object not callable");
            ae.m_line = line;
            throw ae;
        }
        catch (AdenineException ae) {
            ae.addToStackTrace("[function call]", line);
            throw ae;
        }
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            IExpression m_function;
            int m_line;
            Resource m_res;
            ArrayList m_parameters = new ArrayList();
            ArrayList m_namedParameters = new ArrayList();

            IExpression init(Resource res2) throws AdenineException {
                this.m_res = res2;
                Resource resFunction = Utilities.getResourceProperty(res2, AdenineConstants.function, CallInstruction.this.m_source);
                this.m_line = Interpreter.getLineNumber(res2, CallInstruction.this.m_source);
                this.m_function = CallInstruction.this.m_interpreter.compileInstruction(resFunction);
                FunctionCallInstruction.compileParameters(res2, AdenineConstants.PARAMETERS, AdenineConstants.namedParameter, this.m_parameters, this.m_namedParameters, CallInstruction.this.m_source, CallInstruction.this.m_interpreter);
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                throw new UnsupportedOperationException();
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Object o = this.m_function.evaluate(env, denv);
                Vector<Object> v = new Vector<Object>();
                Iterator i = this.m_parameters.iterator();
                while (i.hasNext()) {
                    v.add(((IExpression)i.next()).evaluate(env, denv));
                }
                i = this.m_namedParameters.iterator();
                HashMap<Object, Object> namedParameters = new HashMap<Object, Object>();
                while (i.hasNext()) {
                    IExpression[] pair = (IExpression[])i.next();
                    namedParameters.put(pair[0].evaluate(env, denv), pair[1].evaluate(env, denv));
                }
                Vector returnParameters = new Vector();
                HashMap namedReturnParameters = new HashMap();
                CallInstruction.getReturnParameters(this.m_res, returnParameters, namedReturnParameters, CallInstruction.this.m_source, CallInstruction.this.m_interpreter, env, denv);
                try {
                    return CallInstruction.doFunctionCall(o, v, namedParameters, returnParameters, namedReturnParameters, denv, CallInstruction.this.m_interpreter, this.m_line, env);
                }
                catch (Exception e) {
                    throw new AdenineException("Function call error", e, this.m_line);
                }
            }
        }.init(res);
    }
}

