/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.instructions.ModelInstruction;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.ArrayList;
import java.util.Iterator;

public class BNodeInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        IRDFContainer rdfc = denv.getTarget();
        try {
            Resource resSubject = Utilities.generateUniqueResource();
            Resource[] statements = Utilities.getResourceProperties(res, AdenineConstants.statement, this.m_source);
            int i = 0;
            while (i < statements.length) {
                Resource r = statements[i];
                Object pred = this.m_interpreter.runInstruction((Resource)this.m_source.extract(r, AdenineConstants.predicate, null), env, denv);
                Object obj = this.m_interpreter.runInstruction((Resource)this.m_source.extract(r, AdenineConstants.object, null), env, denv);
                rdfc.add(new Statement(resSubject, (Resource)ModelInstruction.extractNode(pred, rdfc), ModelInstruction.extractNode(obj, rdfc)));
                ++i;
            }
            return resSubject;
        }
        catch (RDFException rdfe) {
            throw new AdenineException("Unknown error", rdfe);
        }
        catch (ClassCastException cce) {
            throw new AdenineException("Type error", cce);
        }
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            ArrayList m_al = new ArrayList();
            int m_line = -1;

            IExpression init(Resource res2) throws AdenineException {
                String strLine = Utilities.getLiteralProperty(res2, AdenineConstants.line, BNodeInstruction.this.m_source);
                if (strLine != null) {
                    try {
                        this.m_line = Integer.parseInt(strLine);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Resource[] statements = Utilities.getResourceProperties(res2, AdenineConstants.statement, BNodeInstruction.this.m_source);
                int i = 0;
                while (i < statements.length) {
                    Resource r = statements[i];
                    IExpression pred = BNodeInstruction.this.m_interpreter.compileInstruction(Utilities.getResourceProperty(r, AdenineConstants.predicate, BNodeInstruction.this.m_source));
                    IExpression obj = BNodeInstruction.this.m_interpreter.compileInstruction(Utilities.getResourceProperty(r, AdenineConstants.object, BNodeInstruction.this.m_source));
                    this.m_al.add(new IExpression[]{pred, obj});
                    ++i;
                }
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                buffer.append(targetVar);
                buffer.append(" = Utilities.generateUniqueResource();\n");
                String ident0 = Interpreter.generateIdentifier();
                String ident1 = Interpreter.generateIdentifier();
                buffer.append("Object ");
                buffer.append(ident0);
                buffer.append(", ");
                buffer.append(ident1);
                buffer.append(";\n");
                Iterator i = this.m_al.iterator();
                while (i.hasNext()) {
                    IExpression[] pair = (IExpression[])i.next();
                    pair[0].generateJava(ident0, buffer, frame, ct);
                    pair[1].generateJava(ident1, buffer, frame, ct);
                    buffer.append("__dynamicenvironment__.getTarget().add(new Statement((Resource)");
                    buffer.append(targetVar);
                    buffer.append(",\n(Resource)ModelInstruction.extractNode(");
                    buffer.append(ident0);
                    buffer.append(",__dynamicenvironment__.getTarget()),\nModelInstruction.extractNode(");
                    buffer.append(ident1);
                    buffer.append(",__dynamicenvironment__.getTarget())));");
                }
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                IRDFContainer rdfc = denv.getTarget();
                try {
                    Resource resSubject = Utilities.generateUniqueResource();
                    Iterator i = this.m_al.iterator();
                    while (i.hasNext()) {
                        IExpression[] pair = (IExpression[])i.next();
                        Object pred = pair[0].evaluate(env, denv);
                        Object obj = pair[1].evaluate(env, denv);
                        rdfc.add(new Statement(resSubject, (Resource)ModelInstruction.extractNode(pred, rdfc), ModelInstruction.extractNode(obj, rdfc)));
                    }
                    return resSubject;
                }
                catch (RDFException rdfe) {
                    throw new AdenineException("Unknown error", rdfe, this.m_line);
                }
                catch (ClassCastException cce) {
                    throw new AdenineException("Type error", cce, this.m_line);
                }
            }
        }.init(res);
    }
}

