/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SyntaxException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;

public class AssignmentInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resLHS = Utilities.getResourceProperty(res, AdenineConstants.LHS, this.m_source);
        Resource resRHS = Utilities.getResourceProperty(res, AdenineConstants.RHS, this.m_source);
        if (Utilities.isType(resLHS, AdenineConstants.Identifier, this.m_source)) {
            Object o = this.m_interpreter.runInstruction(resRHS, env, denv);
            String var = Utilities.getLiteralProperty(resLHS, AdenineConstants.name, this.m_source);
            env.setValue(var, o);
            return o;
        }
        throw new SyntaxException("Invalid l-value: " + resLHS);
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            String m_var;
            IExpression m_rhs;

            IExpression init(Resource res2) throws AdenineException {
                Resource resLHS = Utilities.getResourceProperty(res2, AdenineConstants.LHS, AssignmentInstruction.this.m_source);
                Resource resRHS = Utilities.getResourceProperty(res2, AdenineConstants.RHS, AssignmentInstruction.this.m_source);
                if (!Utilities.isType(resLHS, AdenineConstants.Identifier, AssignmentInstruction.this.m_source)) {
                    throw new SyntaxException("Invalid l-value: " + resLHS);
                }
                this.m_rhs = AssignmentInstruction.this.m_interpreter.compileInstruction(resRHS);
                this.m_var = Utilities.getLiteralProperty(resLHS, AdenineConstants.name, AssignmentInstruction.this.m_source);
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                String temp = Interpreter.generateIdentifier();
                buffer.append("Object ");
                buffer.append(temp);
                buffer.append(";\n");
                this.m_rhs.generateJava(temp, buffer, frame, ct);
                buffer.append(frame.generateVariableName(this.m_var));
                buffer.append(" = ");
                buffer.append(temp);
                buffer.append(";\n");
                buffer.append(targetVar);
                buffer.append(" = null;\n");
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Object o = this.m_rhs.evaluate(env, denv);
                env.setValue(this.m_var, o);
                return o;
            }
        }.init(res);
    }
}

