/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.functions;

import edu.mit.lcs.haystack.ReaderInputStream;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SyntaxException;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.ICallable;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.content.ContentClient;
import edu.mit.lcs.haystack.proxy.IServiceAccessor;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import javax.xml.parsers.DocumentBuilderFactory;

public class XMLDOMFunction
implements ICallable {
    public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {
        Object[] parameters = message.m_values;
        if (parameters.length != 1) {
            throw new SyntaxException("XMLDOM expects one argument.");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        if (parameters[0] instanceof Resource) {
            Resource res = (Resource)parameters[0];
            ContentClient cc = ContentClient.getContentClient((Resource)res, (IRDFContainer)denv.getSource(), (IServiceAccessor)denv.getServiceAccessor());
            try {
                StringBuffer sb = new StringBuffer();
                String str = cc.getContentAsString();
                int i = 0;
                while (i < str.length()) {
                    char ch = str.charAt(i);
                    if (ch >= '\t') {
                        sb.append(ch);
                    }
                    ++i;
                }
                try {
                    return new Message(dbf.newDocumentBuilder().parse(new ReaderInputStream(sb.toString())));
                }
                catch (Exception e) {
                    return new Message(dbf.newDocumentBuilder().parse(cc.getContent()));
                }
            }
            catch (Exception e) {
                throw new AdenineException("Error occurred parsing XML document " + res + ".", e);
            }
        }
        if (parameters[0] instanceof String) {
            try {
                return new Message(dbf.newDocumentBuilder().parse((String)parameters[0]));
            }
            catch (Exception e) {
                throw new AdenineException("XML parsing error.", e);
            }
        }
        throw new SyntaxException("XMLDOM expects a string or a resource.");
    }
}

