/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.functions;

import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.ICallable;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.rdf.Literal;
import java.util.Arrays;
import java.util.List;

public class PlusFunction
implements ICallable {
    public static Number parse(Object o) throws AdenineException {
        String str = null;
        if (o == null) {
            throw new AdenineException("Null is not a number");
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        str = o instanceof Literal ? ((Literal)o).getContent() : (!(o instanceof String) ? o.toString() : (String)o);
        try {
            if (str.indexOf(46) != -1) {
                return new Double(Double.parseDouble(str));
            }
            return new Integer(Integer.parseInt(str));
        }
        catch (Exception e) {
            throw new AdenineException("Number in invalid format: " + o, e);
        }
    }

    public static Object[] upgradeNumberList(Object[] numbers) {
        List params = Interpreter.upgradeNumberCollection(Arrays.asList(numbers));
        return params.toArray();
    }

    public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {
        Object[] parameters = message.m_values;
        Object[] numbers = PlusFunction.upgradeNumberList(parameters);
        if (numbers.length > 0 && numbers[0] instanceof Double) {
            double n = 0.0;
            int i = 0;
            while (i < numbers.length) {
                n += ((Double)numbers[i]).doubleValue();
                ++i;
            }
            return new Message(new Double(n));
        }
        if (numbers.length > 0 && numbers[0] instanceof Long) {
            long n = 0L;
            int i = 0;
            while (i < numbers.length) {
                n += ((Long)numbers[i]).longValue();
                ++i;
            }
            return new Message(new Long(n));
        }
        if (numbers.length > 0 && numbers[0] instanceof Float) {
            float n = 0.0f;
            int i = 0;
            while (i < numbers.length) {
                n += (float)((Float)numbers[i]).longValue();
                ++i;
            }
            return new Message(new Float(n));
        }
        int n = 0;
        int i = 0;
        while (i < numbers.length) {
            n += ((Integer)numbers[i]).intValue();
            ++i;
        }
        return new Message(new Integer(n));
    }
}

