/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.functions;

import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.ICallable;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import org.apache.log4j.Logger;

public class ForkFunction
implements ICallable {
    static Logger s_logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.adenine.functions.ForkFunction;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {
        ForkThread ft;
        Object[] parameters = message.m_values;
        int priority = 5;
        if (parameters[0] instanceof Resource) {
            ft = new ForkThread((Resource)parameters[0]);
            ft.m_parameters = new Object[parameters.length - 1];
            System.arraycopy(parameters, 1, ft.m_parameters, 0, parameters.length - 1);
        } else {
            ft = new ForkThread((Resource)parameters[1]);
            if (parameters[0] instanceof Integer) {
                priority = Math.max(1, Math.min(10, priority + (Integer)parameters[0]));
            } else if (parameters[0] instanceof String) {
                if (parameters[0].equals("min")) {
                    priority = 1;
                } else if (parameters[0].equals("max")) {
                    priority = 10;
                }
            }
            ft.m_parameters = new Object[parameters.length - 2];
            System.arraycopy(parameters, 2, ft.m_parameters, 0, parameters.length - 2);
        }
        ft.m_priority = priority;
        ft.m_denv = (DynamicEnvironment)denv.clone();
        ft.m_source = denv.getSource();
        ft.start();
        return new Message();
    }

    class ForkThread
    extends Thread {
        DynamicEnvironment m_denv;
        IRDFContainer m_source;
        Resource m_service;
        Object[] m_parameters;
        int m_priority;

        public ForkThread(Resource service) {
            super("Adenine fork " + service.getURI());
            this.m_service = service;
        }

        public void run() {
            this.setPriority(this.m_priority);
            StringBuffer s = new StringBuffer(256);
            s.append("\r\n    ");
            s.append(this);
            s.append(" is starting at priority ");
            s.append(this.getPriority());
            s.append(" with parameters");
            int i = 0;
            while (i < this.m_parameters.length) {
                s.append("\r\n      ");
                s.append(this.m_parameters[i]);
                ++i;
            }
            s_logger.info((Object)s);
            Interpreter i2 = new Interpreter(this.m_source);
            try {
                i2.callMethod(this.m_service, this.m_parameters, this.m_denv);
            }
            catch (AdenineException ae) {
                ae.printStackTrace();
            }
            StringBuffer s2 = new StringBuffer(256);
            s2.append("\r\n    ");
            s2.append(this);
            s2.append(" finished");
            s_logger.info((Object)s2);
        }
    }
}

