/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.utils;

import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IParserVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ITopLevelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.URIGenerator;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.HashMap;

public abstract class TopLevelVisitorBase
extends ParserVisitorBase
implements ITopLevelVisitor {
    protected IRDFContainer m_target;
    protected Resource m_base;
    protected HashMap m_prefixes = new HashMap();

    public TopLevelVisitorBase(IParserVisitor visitor, IRDFContainer target) {
        super(visitor);
        this.m_target = target;
        this.m_prefixes.put("random", String.valueOf(Utilities.generateUniqueResource().getURI()) + ":");
        this.m_prefixes.put("adenine", "http://haystack.lcs.mit.edu/schemata/adenine#");
        this.m_prefixes.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.m_prefixes.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.m_prefixes.put("daml", "http://www.daml.org/2001/03/daml+oil#");
        this.m_prefixes.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.m_prefixes.put("", String.valueOf(Utilities.generateUniqueResource().getURI()) + ":");
        this.m_prefixes.put("@urigenerator", new URIGenerator());
    }

    public void onBase(SymbolToken atSignT, Token baseKeyword, ResourceToken baseURI) {
        Resource r = this.resolveURI(baseURI);
        if (r != null) {
            this.setBase(r);
        } else {
            this.onException(new SyntaxException("Base URI cannot be resolved", baseURI.getSpan()));
        }
    }

    public void onPrefix(SymbolToken atSignT, Token prefixKeyword, ResourceToken prefix, ResourceToken expansion) {
        Resource r = this.resolveURI(expansion);
        if (r != null) {
            this.setPrefix(prefix.getPrefix(), r.getContent());
        } else {
            this.onException(new SyntaxException("Prefix expansion cannot be resolved", expansion.getSpan()));
        }
    }

    public Resource getBase() {
        return this.m_base;
    }

    protected void setBase(Resource base) {
        this.m_prefixes.put("@urigenerator", new URIGenerator(base.getContent()));
        this.m_base = base;
    }

    protected void setPrefix(String prefix, String expansion) {
        this.m_prefixes.put(prefix, expansion);
    }

    public Resource resolveURI(ResourceToken r) {
        String s = r.resolveURI(this.m_prefixes);
        if (s == null) {
            return null;
        }
        return new Resource(s);
    }

    public IRDFContainer getTarget() {
        return this.m_target;
    }

    public URIGenerator getURIGenerator() {
        return (URIGenerator)this.m_prefixes.get("@urigenerator");
    }
}

