/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.utils;

import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.ISubExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;
import edu.mit.lcs.haystack.rdf.RDFNode;

public class TopLevelSubExpressionVisitor
extends ParserVisitorBase
implements ISubExpressionVisitor {
    TopLevelVisitorBase m_topLevelVisitor;
    RDFNode m_result;

    public TopLevelSubExpressionVisitor(TopLevelVisitorBase topLevelVisitor) {
        super(topLevelVisitor.getChainedVisitor());
        this.m_topLevelVisitor = topLevelVisitor;
    }

    public void onIdentifier(SymbolToken backquoteT, Token identifier) {
        if (identifier instanceof GenericToken && ((GenericToken)identifier).getContent().equals("^")) {
            this.m_result = this.m_topLevelVisitor.getBase();
            if (backquoteT != null) {
                this.onException(new SyntaxException("Backquote not allowed in top level model", backquoteT.getSpan()));
            }
        } else {
            this.onException(new SyntaxException("Identifier not allowed in top level model", identifier.getSpan()));
        }
    }

    public void onResource(ResourceToken resourceToken) {
        this.m_result = this.m_topLevelVisitor.resolveURI(resourceToken);
        if (this.m_result == null) {
            this.onException(new SyntaxException("Unknown prefix " + resourceToken.getPrefix(), resourceToken.getSpan()));
        }
    }

    public RDFNode getRDFNode() {
        if (this.m_result != null) {
            return this.m_result;
        }
        return null;
    }
}

