/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.utils;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IListVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.LinkedList;
import java.util.List;

public class TopLevelListVisitor
extends ParserVisitorBase
implements IListVisitor {
    TopLevelVisitorBase m_topLevelVisitor;
    Resource m_listResource;
    List m_items = new LinkedList();
    boolean m_error = false;

    public TopLevelListVisitor(TopLevelVisitorBase topLevelVisitor) {
        super(topLevelVisitor.getChainedVisitor());
        this.m_topLevelVisitor = topLevelVisitor;
    }

    public IExpressionVisitor onItem(Location location) {
        return new TopLevelExpressionVisitor(this.m_topLevelVisitor, false){

            public void end(Location endLocation) {
                RDFNode node = this.getRDFNode();
                if (node != null) {
                    TopLevelListVisitor.this.m_items.add(0, node);
                } else {
                    TopLevelListVisitor.this.m_error = true;
                }
            }
        };
    }

    public void onLeftParenthesis(SymbolToken atSignT, SymbolToken leftParenthesisT) {
    }

    public void onRightParenthesis(SymbolToken rightParenthesisT) {
    }

    public void end(Location endLocation) {
        super.end(endLocation);
        if (!this.m_error) {
            if (this.m_items.size() == 0) {
                this.m_listResource = Constants.s_daml_nil;
            } else {
                IRDFContainer target = this.m_topLevelVisitor.getTarget();
                Resource lastNode = Constants.s_daml_nil;
                while (this.m_items.size() > 0) {
                    RDFNode item = (RDFNode)this.m_items.remove(0);
                    this.m_listResource = Utilities.generateUniqueResource();
                    try {
                        target.add(new Statement(this.m_listResource, Constants.s_rdf_type, Constants.s_daml_List));
                        target.add(new Statement(this.m_listResource, Constants.s_daml_rest, lastNode));
                        target.add(new Statement(this.m_listResource, Constants.s_daml_first, item));
                    }
                    catch (RDFException e) {
                        this.onException(e);
                    }
                    lastNode = this.m_listResource;
                }
            }
        }
    }

    public Resource getListResource() {
        return this.m_listResource;
    }
}

