/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.utils;

import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IAttributeVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;

public class TopLevelAttributeVisitor
extends ParserVisitorBase
implements IAttributeVisitor {
    TopLevelVisitorBase m_topLevelVisitor;
    Resource m_subject;
    TopLevelExpressionVisitor m_predicateVisitor;
    TopLevelExpressionVisitor m_objectVisitor;

    public TopLevelAttributeVisitor(TopLevelVisitorBase topLevelVisitor, Resource subject) {
        super(topLevelVisitor.getChainedVisitor());
        this.m_topLevelVisitor = topLevelVisitor;
        this.m_subject = subject;
    }

    public IExpressionVisitor onObject(Location location) {
        this.m_objectVisitor = new TopLevelExpressionVisitor(this.m_topLevelVisitor, false);
        return this.m_objectVisitor;
    }

    public IExpressionVisitor onPredicate(Location location) {
        this.m_predicateVisitor = new TopLevelExpressionVisitor(this.m_topLevelVisitor, false);
        return this.m_predicateVisitor;
    }

    public void end(Location endLocation) {
        super.end(endLocation);
        if (this.m_predicateVisitor != null && this.m_objectVisitor != null) {
            Resource predicate = (Resource)this.m_predicateVisitor.getRDFNode();
            RDFNode object = this.m_objectVisitor.getRDFNode();
            if (predicate != null && object != null && this.m_subject != null) {
                try {
                    this.m_topLevelVisitor.getTarget().add(new Statement(this.m_subject, predicate, object));
                }
                catch (RDFException e) {
                    this.onException(e);
                }
            }
        }
    }
}

