/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ConstructVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.InnerCodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.constructs.IWithVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ICodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.List;

public class WithVisitor
extends ConstructVisitorBase
implements IWithVisitor {
    protected GenericToken m_variable;
    protected ExpressionVisitor m_rhs;
    protected InnerCodeBlockVisitor m_block;
    protected Location m_startLocation;

    public WithVisitor(TopLevelVisitor visitor, List instructionList) {
        super(visitor, instructionList);
    }

    public void start(Location startLocation) {
        this.m_startLocation = startLocation;
    }

    public void end(Location endLocation) {
        if (this.m_variable != null && this.m_rhs != null) {
            Resource lhs = this.m_topLevelVisitor.generateIdentifierInstruction(this.m_variable);
            Resource rhs = this.m_rhs.getInstructionResource();
            if (lhs != null && rhs != null) {
                IRDFContainer target = this.m_topLevelVisitor.getTarget();
                try {
                    Resource block;
                    this.m_topLevelVisitor.makeInstruction(this.m_instructionResource, AdenineConstants.With, this.m_startLocation);
                    target.add(new Statement(this.m_instructionResource, AdenineConstants.LHS, lhs));
                    target.add(new Statement(this.m_instructionResource, AdenineConstants.RHS, rhs));
                    if (this.m_block != null && (block = this.m_block.getFirstInstruction()) != null) {
                        target.add(new Statement(this.m_instructionResource, AdenineConstants.body, block));
                    }
                    super.end(endLocation);
                    return;
                }
                catch (RDFException e) {
                    this.onException(e);
                }
            }
        }
        this.m_instructionResource = null;
        super.end(endLocation);
    }

    public ICodeBlockVisitor onBody() {
        this.m_block = new InnerCodeBlockVisitor(this.m_topLevelVisitor);
        return this.m_block;
    }

    public void onLHS(GenericToken withKeyword, GenericToken variable) {
        this.m_variable = variable;
    }

    public IExpressionVisitor onRHS(Location location) {
        this.m_rhs = new ExpressionVisitor(this.m_topLevelVisitor);
        return this.m_rhs;
    }
}

