/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.AssignmentVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.BlockVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.BreakVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.CallVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ConstructVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ContinueVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ForVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.FunctionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.IfVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ImportJavaVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.MainVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.MethodVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ReturnVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.SkipBlockVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelCallVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelMethodVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.VarVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.WhileVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.WithVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IConstructVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IParserVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullConstructVisitor;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.tokenizer.FloatToken;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.IndentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.IntegerToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Span;
import edu.mit.lcs.haystack.adenine.tokenizer.StringToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TopLevelVisitor
extends TopLevelVisitorBase {
    protected Resource m_package;
    protected LinkedList m_backquotedIdentifierLists = new LinkedList();

    public ConstructVisitorBase getConstruct(String s, List instructionList) {
        if (s.equals("method")) {
            return new MethodVisitor(this, instructionList);
        }
        if (s.equals("=")) {
            return new AssignmentVisitor(this, instructionList);
        }
        if (s.equals("break")) {
            return new BreakVisitor(this, instructionList);
        }
        if (s.equals("block")) {
            return new BlockVisitor(this, instructionList);
        }
        if (s.equals("call")) {
            return new CallVisitor(this, instructionList);
        }
        if (s.equals("continue")) {
            return new ContinueVisitor(this, instructionList);
        }
        if (s.equals("for")) {
            return new ForVisitor(this, instructionList);
        }
        if (s.equals("function")) {
            return new FunctionVisitor(this, instructionList);
        }
        if (s.equals("if")) {
            return new IfVisitor(this, instructionList);
        }
        if (s.equals("importjava")) {
            return new ImportJavaVisitor(this, instructionList);
        }
        if (s.equals("return")) {
            return new ReturnVisitor(this, instructionList);
        }
        if (s.equals("skipBlock")) {
            return new SkipBlockVisitor(this, instructionList);
        }
        if (s.equals("uniqueMethod")) {
            return new MethodVisitor(this, instructionList);
        }
        if (s.equals("var")) {
            return new VarVisitor(this, instructionList);
        }
        if (s.equals("while")) {
            return new WhileVisitor(this, instructionList);
        }
        if (s.equals("with")) {
            return new WithVisitor(this, instructionList);
        }
        return null;
    }

    public TopLevelVisitor(IParserVisitor visitor, Resource pakkage, IRDFContainer target) {
        super(visitor, target);
        this.m_package = pakkage;
    }

    public IConstructVisitor onConstruct(Location location, String construct) {
        if (construct.equals("method")) {
            return new TopLevelMethodVisitor(this);
        }
        if (construct.equals("main")) {
            return new MainVisitor(this);
        }
        if (construct.equals("call")) {
            return new TopLevelCallVisitor(this, null);
        }
        return new NullConstructVisitor(this){

            public void start(Location startLocation) {
                this.onException(new SyntaxException("Unrecognized construct at top level", startLocation));
            }
        };
    }

    public Resource generateInstruction(Resource type, Location location) {
        Resource r = this.getURIGenerator().generateAnonymousResource();
        this.makeInstruction(r, type, location);
        return r;
    }

    public void makeInstruction(Resource instruction, Resource type, Location location) {
        try {
            this.m_target.add(new Statement(instruction, Constants.s_rdf_type, type));
            this.m_target.add(new Statement(instruction, AdenineConstants.line, new Literal(Integer.toString(location.getLine() + 1))));
        }
        catch (RDFException e) {
            this.onException(e);
        }
    }

    public Resource generateIdentifierInstruction(GenericToken token) {
        Resource r = this.generateInstruction(AdenineConstants.Identifier, token.getSpan().getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.name, new Literal(token.getContent())));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public Resource generateLiteralInstruction(Token t, String s) {
        Resource r = this.generateInstruction(AdenineConstants.Literal, t.getSpan().getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.literal, new Literal(s)));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public Resource generateResourceInstruction(ResourceToken token) {
        Resource r = this.resolveURI(token);
        if (r != null) {
            return this.generateResourceInstruction(r, token.getSpan());
        }
        this.onException(new SyntaxException("Unknown prefix " + token.getPrefix() + ":", token.getSpan()));
        return null;
    }

    public Resource generateResourceInstruction(Resource resource, Span span) {
        Resource r = this.generateInstruction(AdenineConstants.Resource, span.getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.resource, resource));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public Resource generateStringInstruction(StringToken token) {
        Resource r = this.generateInstruction(AdenineConstants.String, token.getSpan().getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.string, new Literal(token.getContent())));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public Resource generateIntegerInstruction(IntegerToken token) {
        Resource r = this.generateInstruction(AdenineConstants.Identifier, token.getSpan().getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.name, new Literal(token.getContent())));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public Resource generateFloatInstruction(FloatToken token) {
        Resource r = this.generateInstruction(AdenineConstants.Identifier, token.getSpan().getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.name, new Literal(token.getContent())));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public void setFirstIndent(IndentToken ident) {
    }

    public Resource getPackage() {
        return this.m_package;
    }

    public void pushMethod() {
        this.m_backquotedIdentifierLists.add(0, new HashSet());
    }

    public Set popMethod() {
        return (Set)this.m_backquotedIdentifierLists.remove(0);
    }

    public void addBackquotedIdentifier(String identifier) {
        Set set = (Set)this.m_backquotedIdentifierLists.get(0);
        set.add(identifier);
    }
}

