/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.InnerCodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelAttributeVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelExpressionVisitor;
import edu.mit.lcs.haystack.adenine.constructs.IMethodVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IAttributeVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ICodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullAttributeVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.LinkedList;
import java.util.List;

class TopLevelMethodVisitor
extends ParserVisitorBase
implements IMethodVisitor {
    TopLevelVisitor m_topLevelVisitor;
    List m_parameters = new LinkedList();
    InnerCodeBlockVisitor m_innerBlockVisitor;
    TopLevelExpressionVisitor m_methodResourceVisitor;

    public TopLevelMethodVisitor(TopLevelVisitor topLevelVisitor) {
        super(topLevelVisitor.getChainedVisitor());
        this.m_topLevelVisitor = topLevelVisitor;
    }

    public IAttributeVisitor onAttribute(SymbolToken semicolonT) {
        if (this.getMethodResource() != null) {
            return new TopLevelAttributeVisitor(this.m_topLevelVisitor, this.getMethodResource());
        }
        return new NullAttributeVisitor(this.m_visitor);
    }

    public ICodeBlockVisitor onBlock() {
        IRDFContainer target = this.m_topLevelVisitor.getTarget();
        try {
            target.add(new Statement(this.getMethodResource(), Constants.s_rdf_type, AdenineConstants.Method));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        this.m_innerBlockVisitor = new InnerCodeBlockVisitor(this.m_topLevelVisitor);
        return this.m_innerBlockVisitor;
    }

    public IExpressionVisitor onMethod(GenericToken methodKeyword) {
        this.m_methodResourceVisitor = new TopLevelExpressionVisitor(this.m_topLevelVisitor, true);
        return this.m_methodResourceVisitor;
    }

    public void onNamedParameter(ResourceToken name, SymbolToken equalT, GenericToken parameter) {
        if (this.getMethodResource() != null) {
            IRDFContainer target = this.m_topLevelVisitor.getTarget();
            Resource param = this.m_topLevelVisitor.getURIGenerator().generateAnonymousResource();
            try {
                target.add(new Statement(param, AdenineConstants.parameterName, this.m_topLevelVisitor.resolveURI(name)));
                target.add(new Statement(param, AdenineConstants.parameterVariable, this.m_topLevelVisitor.generateIdentifierInstruction(parameter)));
                target.add(new Statement(this.getMethodResource(), AdenineConstants.namedParameter, param));
            }
            catch (RDFException e) {
                this.onException(e);
            }
        }
    }

    public void onParameter(GenericToken parameter) {
        if (this.getMethodResource() != null) {
            this.m_parameters.add(this.m_topLevelVisitor.generateIdentifierInstruction(parameter));
        }
    }

    public void end(Location endLocation) {
        if (this.getMethodResource() != null) {
            IRDFContainer target = this.m_topLevelVisitor.getTarget();
            try {
                Resource firstInstruction;
                target.add(new Statement(this.getMethodResource(), AdenineConstants.PARAMETERS, ListUtilities.createDAMLList(this.m_parameters.iterator(), target)));
                Resource resource = firstInstruction = this.m_innerBlockVisitor != null ? this.m_innerBlockVisitor.getFirstInstruction() : null;
                if (firstInstruction != null) {
                    target.add(new Statement(this.getMethodResource(), AdenineConstants.start, firstInstruction));
                }
            }
            catch (RDFException e) {
                this.onException(e);
            }
        }
    }

    public boolean canBeAnonymous() {
        return false;
    }

    Resource getMethodResource() {
        return this.m_methodResourceVisitor.getResource();
    }
}

