/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.ISubExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;
import edu.mit.lcs.haystack.rdf.Resource;

public class SubExpressionVisitor
extends ParserVisitorBase
implements ISubExpressionVisitor {
    protected TopLevelVisitor m_topLevelVisitor;
    protected Resource m_instructionResource;

    public SubExpressionVisitor(TopLevelVisitor visitor) {
        super(visitor);
        this.m_topLevelVisitor = visitor;
    }

    public Resource getInstructionResource() {
        return this.m_instructionResource;
    }

    public void onIdentifier(SymbolToken backquoteT, Token identifier) {
        if (identifier instanceof GenericToken && ((GenericToken)identifier).getContent().equals("^")) {
            Resource r;
            if (backquoteT != null) {
                this.onException(new SyntaxException("Backquote not allowed after ^", backquoteT.getSpan()));
            }
            if ((r = this.m_topLevelVisitor.getBase()) != null) {
                this.m_instructionResource = this.m_topLevelVisitor.generateResourceInstruction(r, identifier.getSpan());
            } else {
                this.onException(new SyntaxException("Base ^ has not been defined", identifier.getSpan()));
            }
        } else {
            GenericToken i = (GenericToken)identifier;
            this.m_instructionResource = this.m_topLevelVisitor.generateIdentifierInstruction(i);
            if (backquoteT != null) {
                this.m_topLevelVisitor.addBackquotedIdentifier(i.getContent());
            }
        }
    }

    public void onResource(ResourceToken resourceToken) {
        this.m_instructionResource = this.m_topLevelVisitor.generateResourceInstruction(resourceToken);
    }
}

