/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IListVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.ArrayList;
import java.util.List;

public class ListVisitor
extends ParserVisitorBase
implements IListVisitor {
    protected TopLevelVisitor m_topLevelVisitor;
    protected Resource m_instructionResource;
    protected List m_arguments = new ArrayList();

    public ListVisitor(TopLevelVisitor visitor) {
        super(visitor);
        this.m_topLevelVisitor = visitor;
    }

    public void end(Location endLocation) {
        IRDFContainer target = this.m_topLevelVisitor.getTarget();
        this.m_instructionResource = this.m_topLevelVisitor.generateInstruction(AdenineConstants.FunctionCall, this.m_startLocation);
        ArrayList<Resource> arguments = new ArrayList<Resource>();
        int i = 0;
        while (i < this.m_arguments.size()) {
            Resource r = ((ExpressionVisitor)this.m_arguments.get(i)).getInstructionResource();
            if (r != null) {
                arguments.add(r);
            }
            ++i;
        }
        try {
            Resource identifier = this.m_topLevelVisitor.generateInstruction(AdenineConstants.Identifier, this.m_startLocation);
            target.add(new Statement(identifier, AdenineConstants.name, new Literal("List")));
            target.add(new Statement(this.m_instructionResource, AdenineConstants.function, identifier));
            target.add(new Statement(this.m_instructionResource, AdenineConstants.PARAMETERS, ListUtilities.createDAMLList(arguments.iterator(), target)));
        }
        catch (RDFException e) {
            this.onException(e);
        }
    }

    public IExpressionVisitor onItem(Location location) {
        ExpressionVisitor ev = new ExpressionVisitor(this.m_topLevelVisitor);
        this.m_arguments.add(ev);
        return ev;
    }

    public void onLeftParenthesis(SymbolToken atSignT, SymbolToken leftParenthesisT) {
    }

    public void onRightParenthesis(SymbolToken rightParenthesisT) {
    }
}

