/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ConstructVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.InnerCodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.constructs.IIfVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ICodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.List;

public class IfVisitor
extends ConstructVisitorBase
implements IIfVisitor {
    protected ExpressionVisitor m_condition;
    protected InnerCodeBlockVisitor m_blockIf;
    protected InnerCodeBlockVisitor m_blockElse;
    protected Location m_startLocation;

    public IfVisitor(TopLevelVisitor visitor, List instructionList) {
        super(visitor, instructionList);
    }

    public void end(Location endLocation) {
        Resource condition;
        if (this.m_condition != null && (condition = this.m_condition.getInstructionResource()) != null) {
            IRDFContainer target = this.m_topLevelVisitor.getTarget();
            this.m_topLevelVisitor.makeInstruction(this.m_instructionResource, AdenineConstants.If, this.m_startLocation);
            try {
                Resource block;
                target.add(new Statement(this.m_instructionResource, AdenineConstants.CONDITION, condition));
                if (this.m_blockIf != null && (block = this.m_blockIf.getFirstInstruction()) != null) {
                    target.add(new Statement(this.m_instructionResource, AdenineConstants.body, block));
                }
                if (this.m_blockElse != null && (block = this.m_blockElse.getFirstInstruction()) != null) {
                    target.add(new Statement(this.m_instructionResource, AdenineConstants.ELSEBODY, block));
                }
                super.end(endLocation);
                return;
            }
            catch (RDFException e) {
                this.onException(e);
            }
        }
        this.m_instructionResource = null;
        super.end(endLocation);
    }

    public IExpressionVisitor onIf(GenericToken ifKeyword) {
        this.m_startLocation = ifKeyword.getSpan().getStart();
        this.m_condition = new ExpressionVisitor(this.m_topLevelVisitor);
        return this.m_condition;
    }

    public ICodeBlockVisitor onIfBody(Location location) {
        this.m_blockIf = new InnerCodeBlockVisitor(this.m_topLevelVisitor);
        return this.m_blockIf;
    }

    public IExpressionVisitor onElseIf(GenericToken ifKeyword) {
        this.m_startLocation = ifKeyword.getSpan().getStart();
        this.m_condition = new ExpressionVisitor(this.m_topLevelVisitor);
        return this.m_condition;
    }

    public ICodeBlockVisitor onElseIfBody(Location location) {
        this.m_blockIf = new InnerCodeBlockVisitor(this.m_topLevelVisitor);
        return this.m_blockIf;
    }

    public ICodeBlockVisitor onElse(GenericToken elseKeyword) {
        this.m_blockElse = new InnerCodeBlockVisitor(this.m_topLevelVisitor);
        return this.m_blockElse;
    }
}

