/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ConstructVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.InnerCodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.constructs.IFunctionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ICodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.LinkedList;
import java.util.List;

public class FunctionVisitor
extends ConstructVisitorBase
implements IFunctionVisitor {
    List m_parameters = new LinkedList();
    InnerCodeBlockVisitor m_innerBlockVisitor;

    public FunctionVisitor(TopLevelVisitor visitor, List instructionList) {
        super(visitor, instructionList);
    }

    public void onFunction(GenericToken functionKeyword, GenericToken name) {
        if (name instanceof GenericToken) {
            this.m_topLevelVisitor.makeInstruction(this.m_instructionResource, AdenineConstants.Function, name.getSpan().getStart());
            Resource function = this.m_topLevelVisitor.generateIdentifierInstruction(name);
            try {
                this.m_topLevelVisitor.getTarget().add(new Statement(this.m_instructionResource, AdenineConstants.function, function));
            }
            catch (RDFException e) {
                this.onException(e);
            }
        } else {
            this.onException(new SyntaxException("Expected a generic token for anonymous function name", name.getSpan()));
        }
    }

    public void onParameter(GenericToken parameter) {
        if (this.m_instructionResource != null) {
            this.m_parameters.add(this.m_topLevelVisitor.generateIdentifierInstruction(parameter));
        }
    }

    public ICodeBlockVisitor onBody() {
        this.m_innerBlockVisitor = new InnerCodeBlockVisitor(this.m_topLevelVisitor);
        return this.m_innerBlockVisitor;
    }

    public void start(Location startLocation) {
        super.start(startLocation);
        this.m_topLevelVisitor.pushMethod();
    }

    public void end(Location endLocation) {
        if (this.m_instructionResource != null) {
            IRDFContainer target = this.m_topLevelVisitor.getTarget();
            try {
                Resource firstInstruction;
                target.add(new Statement(this.m_instructionResource, AdenineConstants.PARAMETERS, ListUtilities.createDAMLList(this.m_parameters.iterator(), target)));
                Resource resource = firstInstruction = this.m_innerBlockVisitor != null ? this.m_innerBlockVisitor.getFirstInstruction() : null;
                if (firstInstruction != null) {
                    target.add(new Statement(this.m_instructionResource, AdenineConstants.body, firstInstruction));
                }
            }
            catch (RDFException e) {
                this.onException(e);
            }
        }
        super.end(endLocation);
    }
}

