/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.AnonymousModelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ApplyVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.AskModelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ListVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ModelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.SubExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IAnonymousModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IApplyVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IAskModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IListVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ISubExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullSubExpressionVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.FloatToken;
import edu.mit.lcs.haystack.adenine.tokenizer.IntegerToken;
import edu.mit.lcs.haystack.adenine.tokenizer.LiteralToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.StringToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;

public class ExpressionVisitor
extends ParserVisitorBase
implements IExpressionVisitor {
    protected TopLevelVisitor m_topLevelVisitor;
    protected Resource m_instructionResource;

    public ExpressionVisitor(TopLevelVisitor visitor) {
        super(visitor);
        this.m_topLevelVisitor = visitor;
    }

    public Resource getInstructionResource() {
        return this.m_instructionResource;
    }

    public ISubExpressionVisitor onDereference(SymbolToken periodT) {
        if (this.m_instructionResource != null) {
            return new SubExpressionVisitor(this.m_topLevelVisitor){
                Location m_location;

                public void end(Location endLocation) {
                    super.end(endLocation);
                    ExpressionVisitor.this.setDereference(this.m_instructionResource, this.m_location);
                }

                public SubExpressionVisitor init(Location location) {
                    this.m_location = location;
                    return this;
                }
            }.init(periodT.getSpan().getStart());
        }
        return new NullSubExpressionVisitor(this.m_topLevelVisitor.getChainedVisitor());
    }

    void setDereference(Resource ref, Location location) {
        if (this.m_instructionResource != null && ref != null) {
            IRDFContainer target = this.m_topLevelVisitor.getTarget();
            Resource base = this.m_instructionResource;
            this.m_instructionResource = this.m_topLevelVisitor.generateInstruction(AdenineConstants.Dereferencement, location);
            try {
                target.add(new Statement(this.m_instructionResource, AdenineConstants.base, base));
                target.add(new Statement(this.m_instructionResource, AdenineConstants.member, ref));
            }
            catch (RDFException e) {
                this.onException(e);
            }
        }
    }

    public IExpressionVisitor onLeftBracket(SymbolToken leftBracketT) {
        if (this.m_instructionResource != null) {
            return new InnerExpressionVisitor(this.m_topLevelVisitor, leftBracketT.getSpan().getStart());
        }
        return new NullExpressionVisitor(this.m_topLevelVisitor.getChainedVisitor());
    }

    void setIndexInstruction(Resource index, Location location) {
        if (this.m_instructionResource != null && index != null) {
            IRDFContainer target = this.m_topLevelVisitor.getTarget();
            Resource base = this.m_instructionResource;
            this.m_instructionResource = this.m_topLevelVisitor.generateInstruction(AdenineConstants.Index, location);
            try {
                target.add(new Statement(this.m_instructionResource, AdenineConstants.base, base));
                target.add(new Statement(this.m_instructionResource, AdenineConstants.index, index));
            }
            catch (RDFException e) {
                this.onException(e);
            }
        }
    }

    public void onRightBracket(SymbolToken rightBracketT) {
    }

    public ISubExpressionVisitor onSubExpression(Location location) {
        return new SubExpressionVisitor(this.m_topLevelVisitor){

            public void end(Location endLocation) {
                super.end(endLocation);
                ExpressionVisitor.this.m_instructionResource = this.m_instructionResource;
            }
        };
    }

    public IAnonymousModelVisitor onAnonymousModel(Location location) {
        return new AnonymousModelVisitor(this.m_topLevelVisitor){

            public void end(Location endLocation) {
                super.end(endLocation);
                ExpressionVisitor.this.m_instructionResource = this.m_instructionResource;
            }
        };
    }

    public IApplyVisitor onApply(Location location) {
        return new ApplyVisitor(this.m_topLevelVisitor){

            public void end(Location endLocation) {
                super.end(endLocation);
                ExpressionVisitor.this.m_instructionResource = this.m_instructionResource;
            }
        };
    }

    public IAskModelVisitor onAskModel(Location location) {
        return new AskModelVisitor(this.m_topLevelVisitor){

            public void end(Location endLocation) {
                super.end(endLocation);
                ExpressionVisitor.this.m_instructionResource = this.m_instructionResource;
            }
        };
    }

    public void onFloat(FloatToken floatToken) {
        this.m_instructionResource = this.m_topLevelVisitor.generateFloatInstruction(floatToken);
    }

    public void onInteger(IntegerToken integerToken) {
        this.m_instructionResource = this.m_topLevelVisitor.generateIntegerInstruction(integerToken);
    }

    public IListVisitor onList(Location location) {
        return new ListVisitor(this.m_topLevelVisitor){

            public void end(Location endLocation) {
                super.end(endLocation);
                ExpressionVisitor.this.m_instructionResource = this.m_instructionResource;
            }
        };
    }

    public void onLiteral(LiteralToken literalToken) {
        this.m_instructionResource = this.m_topLevelVisitor.generateLiteralInstruction(literalToken, literalToken.getContent());
    }

    public IModelVisitor onModel(Location location) {
        return new ModelVisitor(this.m_topLevelVisitor){

            public void end(Location endLocation) {
                super.end(endLocation);
                ExpressionVisitor.this.m_instructionResource = this.m_instructionResource;
            }
        };
    }

    public void onString(StringToken stringToken) {
        this.m_instructionResource = this.m_topLevelVisitor.generateStringInstruction(stringToken);
    }

    class InnerExpressionVisitor
    extends ExpressionVisitor {
        Location m_location;

        public InnerExpressionVisitor(TopLevelVisitor visitor, Location location) {
            super(visitor);
            this.m_location = location;
        }

        public void end(Location endLocation) {
            super.end(endLocation);
            ExpressionVisitor.this.setIndexInstruction(this.getInstructionResource(), this.m_location);
        }
    }
}

