/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IAskModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullExpressionVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.Iterator;
import java.util.LinkedList;

public class AskModelVisitor
extends ParserVisitorBase
implements IAskModelVisitor {
    protected TopLevelVisitor m_topLevelVisitor;
    protected LinkedList m_conditions = new LinkedList();
    protected LinkedList m_condition;
    protected Resource m_instructionResource;

    public AskModelVisitor(TopLevelVisitor topLevelVisitor) {
        super(topLevelVisitor);
        this.m_topLevelVisitor = topLevelVisitor;
    }

    public void onModelEnd(SymbolToken rightBraceT) {
    }

    public void onModelStart(SymbolToken percentSignT, SymbolToken leftBraceT) {
    }

    public void onConditionStart(SymbolToken commaT) {
        this.m_condition = new LinkedList();
    }

    public void onConditionEnd(Location location) {
        if (this.m_condition != null) {
            this.m_conditions.add(this.m_condition);
            this.m_condition = null;
        }
    }

    public IExpressionVisitor onConditionTerm(Location location) {
        if (this.m_condition != null) {
            ExpressionVisitor v = new ExpressionVisitor(this.m_topLevelVisitor);
            this.m_condition.add(v);
            return v;
        }
        return new NullExpressionVisitor(this.m_topLevelVisitor.getChainedVisitor());
    }

    public void end(Location endLocation) {
        IRDFContainer target = this.m_topLevelVisitor.getTarget();
        LinkedList<Resource> conditionResources = new LinkedList<Resource>();
        this.m_instructionResource = this.m_topLevelVisitor.generateInstruction(AdenineConstants.Query, this.m_startLocation);
        try {
            Iterator c = this.m_conditions.iterator();
            while (c.hasNext()) {
                LinkedList terms = (LinkedList)c.next();
                Iterator v = terms.iterator();
                LinkedList<Resource> instructionResources = new LinkedList<Resource>();
                while (v.hasNext()) {
                    ExpressionVisitor visitor = (ExpressionVisitor)v.next();
                    instructionResources.add(visitor.getInstructionResource());
                }
                conditionResources.add(ListUtilities.createDAMLList(instructionResources.iterator(), target));
            }
            target.add(new Statement(this.m_instructionResource, AdenineConstants.conditions, ListUtilities.createDAMLList(conditionResources.iterator(), target)));
        }
        catch (RDFException e) {
            this.onException(e);
        }
    }
}

