/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IApplyVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.ArrayList;
import java.util.List;

public class ApplyVisitor
extends ParserVisitorBase
implements IApplyVisitor {
    protected TopLevelVisitor m_topLevelVisitor;
    protected Resource m_instructionResource;
    protected List m_arguments = new ArrayList();
    protected List m_argumentNames = new ArrayList();
    protected List m_namedArguments = new ArrayList();
    protected ExpressionVisitor m_callable;

    public ApplyVisitor(TopLevelVisitor visitor) {
        super(visitor);
        this.m_topLevelVisitor = visitor;
    }

    public IExpressionVisitor onArgument(Location location) {
        ExpressionVisitor ev = new ExpressionVisitor(this.m_topLevelVisitor);
        this.m_arguments.add(ev);
        return ev;
    }

    public IExpressionVisitor onCallable(Location location) {
        this.m_callable = new ExpressionVisitor(this.m_topLevelVisitor);
        return this.m_callable;
    }

    public IExpressionVisitor onNamedArgument(ResourceToken name, SymbolToken equalT) {
        ExpressionVisitor ev = new ExpressionVisitor(this.m_topLevelVisitor);
        this.m_namedArguments.add(ev);
        this.m_argumentNames.add(name);
        return ev;
    }

    public void end(Location endLocation) {
        Resource callable;
        if (this.m_callable != null && (callable = this.m_callable.getInstructionResource()) != null) {
            IRDFContainer target = this.m_topLevelVisitor.getTarget();
            this.m_instructionResource = this.m_topLevelVisitor.generateInstruction(AdenineConstants.FunctionCall, this.m_startLocation);
            ArrayList<Resource> arguments = new ArrayList<Resource>();
            int i = 0;
            while (i < this.m_arguments.size()) {
                Resource r = ((ExpressionVisitor)this.m_arguments.get(i)).getInstructionResource();
                if (r != null) {
                    arguments.add(r);
                }
                ++i;
            }
            i = 0;
            while (i < this.m_namedArguments.size()) {
                Resource a = ((ExpressionVisitor)this.m_namedArguments.get(i)).getInstructionResource();
                Resource n = this.m_topLevelVisitor.resolveURI((ResourceToken)this.m_argumentNames.get(i));
                if (a != null && n != null) {
                    Resource r = this.m_topLevelVisitor.getURIGenerator().generateAnonymousResource();
                    try {
                        target.add(new Statement(r, AdenineConstants.parameterName, n));
                        target.add(new Statement(r, AdenineConstants.parameterVariable, a));
                        target.add(new Statement(this.m_instructionResource, AdenineConstants.namedParameter, r));
                    }
                    catch (RDFException e) {
                        this.onException(e);
                    }
                }
                ++i;
            }
            try {
                target.add(new Statement(this.m_instructionResource, AdenineConstants.function, this.m_callable.getInstructionResource()));
                target.add(new Statement(this.m_instructionResource, AdenineConstants.PARAMETERS, ListUtilities.createDAMLList(arguments.iterator(), target)));
            }
            catch (RDFException e) {
                this.onException(e);
            }
        }
    }

    public void onLeftParenthesis(SymbolToken leftParenthesisT) {
    }

    public void onRightParenthesis(SymbolToken rightParenthesisT) {
    }
}

