/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.javaByteCode;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.AssignmentVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.BlockVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.BreakVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.CallVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.CodeFrame;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.ConstructVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.ContinueVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.ForVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.FunctionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.IfVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.ImportJavaVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.JavaByteCodeCompiler;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.MainVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.MethodVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.ReturnVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.SkipBlockVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.TopLevelCallVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.TopLevelMethodVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.UniqueMethodVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.VarVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.WhileVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.WithVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IConstructVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IParserVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullConstructVisitor;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.tokenizer.FloatToken;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.IndentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.IntegerToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.StringToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class TopLevelVisitor
extends TopLevelVisitorBase {
    protected Resource m_package;
    protected JavaByteCodeCompiler m_compiler;
    protected LinkedList m_backquotedIdentifierLists = new LinkedList();

    public ConstructVisitorBase getConstruct(String s, CodeFrame codeFrame) {
        if (s.equals("method")) {
            return new MethodVisitor(this, codeFrame);
        }
        if (s.equals("=")) {
            return new AssignmentVisitor(this, codeFrame);
        }
        if (s.equals("block")) {
            return new BlockVisitor(this, codeFrame);
        }
        if (s.equals("break")) {
            return new BreakVisitor(this, codeFrame);
        }
        if (s.equals("call")) {
            return new CallVisitor(this, codeFrame);
        }
        if (s.equals("continue")) {
            return new ContinueVisitor(this, codeFrame);
        }
        if (s.equals("for")) {
            return new ForVisitor(this, codeFrame);
        }
        if (s.equals("function")) {
            return new FunctionVisitor(this, codeFrame);
        }
        if (s.equals("if")) {
            return new IfVisitor(this, codeFrame);
        }
        if (s.equals("importjava")) {
            return new ImportJavaVisitor(this, codeFrame);
        }
        if (s.equals("skipBlock")) {
            return new SkipBlockVisitor(this, codeFrame);
        }
        if (s.equals("return")) {
            return new ReturnVisitor(this, codeFrame);
        }
        if (s.equals("uniqueMethod")) {
            return new UniqueMethodVisitor(this, codeFrame);
        }
        if (s.equals("var")) {
            return new VarVisitor(this, codeFrame);
        }
        if (s.equals("while")) {
            return new WhileVisitor(this, codeFrame);
        }
        if (s.equals("with")) {
            return new WithVisitor(this, codeFrame);
        }
        return null;
    }

    public TopLevelVisitor(IParserVisitor visitor, Resource pakkage, IRDFContainer target, JavaByteCodeCompiler compiler) {
        super(visitor, target);
        this.m_package = pakkage;
        this.m_compiler = compiler;
    }

    public JavaByteCodeCompiler getCompiler() {
        return this.m_compiler;
    }

    public IConstructVisitor onConstruct(Location location, String construct) {
        if (construct.equals("method")) {
            return new TopLevelMethodVisitor(this);
        }
        if (construct.equals("main")) {
            return new MainVisitor(this);
        }
        if (construct.equals("call")) {
            return new TopLevelCallVisitor(this, null);
        }
        return new NullConstructVisitor(this){

            public void start(Location startLocation) {
                this.onException(new SyntaxException("Unrecognized construct at top level", startLocation));
            }
        };
    }

    public Resource generateInstruction(Resource type, Location location) {
        Resource r = this.getURIGenerator().generateAnonymousResource();
        this.makeInstruction(r, type, location);
        return r;
    }

    public void makeInstruction(Resource instruction, Resource type, Location location) {
        try {
            this.m_target.add(new Statement(instruction, Constants.s_rdf_type, type));
            this.m_target.add(new Statement(instruction, AdenineConstants.line, new Literal(Integer.toString(location.getLine() + 1))));
        }
        catch (RDFException e) {
            this.onException(e);
        }
    }

    public Resource generateIdentifierInstruction(GenericToken token) {
        Resource r = this.generateInstruction(AdenineConstants.Identifier, token.getSpan().getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.name, new Literal(token.getContent())));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public Resource generateIdentifierInstruction(String name) {
        Resource r = this.getURIGenerator().generateAnonymousResource();
        try {
            this.m_target.add(new Statement(r, Constants.s_rdf_type, AdenineConstants.Identifier));
            this.m_target.add(new Statement(r, AdenineConstants.name, new Literal(name)));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public Resource generateLiteralInstruction(Token t, String s) {
        Resource r = this.generateInstruction(AdenineConstants.Literal, t.getSpan().getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.literal, new Literal(s)));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public Resource generateResourceInstruction(ResourceToken token) {
        Resource r = this.generateInstruction(AdenineConstants.Resource, token.getSpan().getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.resource, this.resolveURI(token)));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public Resource generateStringInstruction(StringToken token) {
        Resource r = this.generateInstruction(AdenineConstants.String, token.getSpan().getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.string, new Literal(token.getContent())));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public Resource generateIntegerInstruction(IntegerToken token) {
        Resource r = this.generateInstruction(AdenineConstants.Identifier, token.getSpan().getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.name, new Literal(token.getContent())));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public Resource generateFloatInstruction(FloatToken token) {
        Resource r = this.generateInstruction(AdenineConstants.Identifier, token.getSpan().getStart());
        try {
            this.m_target.add(new Statement(r, AdenineConstants.name, new Literal(token.getContent())));
        }
        catch (RDFException e) {
            this.onException(e);
        }
        return r;
    }

    public void setFirstIndent(IndentToken ident) {
    }

    public Resource getPackage() {
        return this.m_package;
    }

    public void pushMethod() {
        this.m_backquotedIdentifierLists.add(0, new HashSet());
    }

    public Set popMethod() {
        return (Set)this.m_backquotedIdentifierLists.remove(0);
    }

    public void addBackquotedIdentifier(String identifier) {
        Set set = (Set)this.m_backquotedIdentifierLists.get(0);
        set.add(identifier);
    }
}

