/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.javaByteCode;

import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.CodeFrame;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.JavaByteCodeUtilities;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.ParserVisitorBase2;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ISubExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Span;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;
import edu.mit.lcs.haystack.rdf.Resource;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

public class SubExpressionVisitor
extends ParserVisitorBase2
implements ISubExpressionVisitor {
    public SubExpressionVisitor(TopLevelVisitor visitor, CodeFrame codeFrame) {
        super(visitor, codeFrame);
    }

    public void onIdentifier(SymbolToken backquoteT, Token identifier) {
        if (identifier instanceof GenericToken && ((GenericToken)identifier).getContent().equals("^")) {
            Resource r;
            if (backquoteT != null) {
                this.onException(new SyntaxException("Backquote not allowed after ^", backquoteT.getSpan()));
            }
            if ((r = this.m_topLevelVisitor.getBase()) != null) {
                this.addResource(r, identifier.getSpan());
            } else {
                this.onException(new SyntaxException("Base ^ as not been defined", identifier.getSpan()));
            }
        } else {
            GenericToken i = (GenericToken)identifier;
            String name = i.getContent();
            if (backquoteT != null) {
                this.m_topLevelVisitor.addBackquotedIdentifier(name);
                this.m_codeFrame.addTopVariable(name);
            }
            this.onIdentifier(name, i);
        }
    }

    public void onResource(ResourceToken resourceToken) {
        Resource r = this.m_topLevelVisitor.resolveURI(resourceToken);
        if (r != null) {
            this.addResource(r, resourceToken.getSpan());
        } else {
            this.onException(new SyntaxException("Unknown prefix " + resourceToken.getPrefix(), resourceToken.getSpan()));
        }
    }

    protected void addResource(Resource resource, Span span) {
        InstructionList iList = this.m_codeFrame.getInstructionList();
        MethodGen mg = this.m_codeFrame.getMethodGen();
        int line = span.getStart().getTrueLine();
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createNew(JavaByteCodeUtilities.s_typeResource)), line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.DUP), line);
        mg.addLineNumber(iList.append((CompoundInstruction)new PUSH(this.m_codeFrame.getConstantPoolGen(), resource.getURI())), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createInvoke(JavaByteCodeUtilities.s_typeResource.getClassName(), "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183)), line);
    }

    protected void onIdentifier(String identifier, GenericToken token) {
        this.m_codeFrame.generateVariableGet(identifier, this.m_codeFrame.getInstructionList(), this.m_codeFrame.getMethodGen(), token.getSpan().getStart().getTrueLine());
    }
}

