/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.javaByteCode;

import java.text.MessageFormat;
import java.util.Iterator;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.MethodGen;

public class JavaClassPrettyPrinter {
    public static void main(String[] argv) {
        try {
            System.out.println("class " + argv[0]);
            JavaClass clazz = Repository.lookupClass((String)argv[0]);
            ConstantPoolGen cp = new ConstantPoolGen(clazz.getConstantPool());
            Field[] fields = clazz.getFields();
            int i = 0;
            while (i < fields.length) {
                FieldGen fg = new FieldGen(fields[i], cp);
                JavaClassPrettyPrinter.printField(fg);
                ++i;
            }
            Method[] methods = clazz.getMethods();
            i = 0;
            while (i < methods.length) {
                MethodGen mg = new MethodGen(methods[i], clazz.getClassName(), cp);
                JavaClassPrettyPrinter.printMethod(mg);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void printField(FieldGen fg) {
        System.out.println("Field " + fg.getName() + ": " + fg.getSignature());
    }

    protected static void printMethod(MethodGen mg) {
        System.out.println("Method " + mg.getName() + ": " + mg.getSignature());
        ConstantPoolGen cpg = mg.getConstantPool();
        ConstantPool cp = cpg.getConstantPool();
        InstructionList il = mg.getInstructionList();
        Iterator i = il.iterator();
        int maxStack = mg.getMaxStack();
        StringBuffer s = new StringBuffer(maxStack);
        LineNumberGen[] lng = mg.getLineNumbers();
        int iCount = 1;
        while (i.hasNext()) {
            InstructionHandle ih = (InstructionHandle)i.next();
            Instruction ins = ih.getInstruction();
            int offset = ih.getPosition();
            String f = MessageFormat.format("{0,number,00000}. {1,number,00000} ", new Integer(iCount++), new Integer(offset));
            if (!JavaClassPrettyPrinter.adjustStringBuffer(s, ins.produceStack(cpg) - ins.consumeStack(cpg))) {
                System.out.println("----stack underflow----");
            }
            System.out.println(String.valueOf(f) + s.toString() + ih.getInstruction().toString(cp));
        }
        System.out.println("\r\n\r\n");
    }

    protected static boolean adjustStringBuffer(StringBuffer s, int diff) {
        if (diff > 0) {
            while (diff > 0) {
                s.append(".   ");
                --diff;
            }
        } else if (diff < 0) {
            if ((diff = -diff) > s.length()) {
                return false;
            }
            s.delete(0, diff * 4);
        }
        return true;
    }
}

