/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.javaByteCode;

import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.JavaByteCodeUtilities;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

public class CodeFrame {
    protected CodeFrame m_parentFrame;
    protected List m_childFrames = new ArrayList();
    protected String m_frameName;
    protected ClassGen m_classGen;
    protected ConstantPoolGen m_constantPoolGen;
    protected InstructionFactory m_iFactory;
    protected InstructionList m_iList;
    protected Set m_variables = new HashSet();
    protected Set m_defaultEnvironmentVariables;
    protected boolean m_error = false;
    static /* synthetic */ Class class$0;

    public CodeFrame(String frameName, ClassGen classGen) {
        this(frameName, classGen, new HashSet());
    }

    public CodeFrame(String frameName, CodeFrame parentFrame) {
        this(frameName, parentFrame, true, true);
    }

    public CodeFrame(String frameName, CodeFrame parentFrame, boolean hookParent, boolean hookChild) {
        this(frameName, parentFrame.getClassGen(), parentFrame.getDefaultEnvironmentVariables());
        if (hookParent) {
            this.m_parentFrame = parentFrame;
        }
        if (hookChild) {
            parentFrame.m_childFrames.add(this);
        }
    }

    protected CodeFrame(String frameName, ClassGen classGen, Set defaultEnvironmentVariables) {
        this.m_classGen = classGen;
        this.m_frameName = frameName;
        this.m_constantPoolGen = classGen.getConstantPool();
        this.m_iList = new InstructionList();
        this.m_iFactory = new InstructionFactory(classGen);
        this.m_defaultEnvironmentVariables = defaultEnvironmentVariables;
    }

    public ClassGen getClassGen() {
        return this.m_classGen;
    }

    public MethodGen getMethodGen() {
        return this.m_parentFrame != null ? this.m_parentFrame.getMethodGen() : null;
    }

    public InstructionList getInstructionList() {
        return this.m_iList;
    }

    public InstructionFactory getInstructionFactory() {
        return this.m_iFactory;
    }

    public ConstantPoolGen getConstantPoolGen() {
        return this.m_constantPoolGen;
    }

    public boolean getError() {
        return this.m_error;
    }

    public void setError() {
        this.m_error = true;
        if (this.m_parentFrame != null) {
            this.m_parentFrame.setError();
        }
    }

    public boolean addBreakBranch(int line) {
        return this.internalAddBreakBranch(this.getMethodGen(), this.m_iList, line);
    }

    public boolean addBreakBranch(BranchHandle handle, int line) {
        return this.internalAddBreakBranch(this.getMethodGen(), this.m_iList, handle, line);
    }

    protected boolean internalAddBreakBranch(MethodGen mg, InstructionList iList, BranchHandle handle, int line) {
        InstructionList iList2 = new InstructionList();
        this.addCleanupCode(mg, iList2, line);
        iList.insert((InstructionHandle)handle, iList);
        if (this.m_parentFrame != null) {
            return this.m_parentFrame.internalAddBreakBranch(mg, iList, handle, line);
        }
        return false;
    }

    protected boolean internalAddBreakBranch(MethodGen mg, InstructionList iList, int line) {
        this.addCleanupCode(mg, iList, line);
        if (this.m_parentFrame != null) {
            return this.m_parentFrame.internalAddBreakBranch(mg, iList, line);
        }
        return false;
    }

    public boolean addContinueBranch(int line) {
        return this.internalAddContinueBranch(this.getMethodGen(), this.m_iList, line);
    }

    protected boolean internalAddContinueBranch(MethodGen mg, InstructionList iList, int line) {
        this.addCleanupCode(mg, iList, line);
        if (this.m_parentFrame != null) {
            return this.m_parentFrame.internalAddContinueBranch(mg, iList, line);
        }
        return false;
    }

    public void addReturnBranch(int line) {
        MethodGen mg = this.getMethodGen();
        LocalVariableGen lvg = mg.addLocalVariable("result", (Type)JavaByteCodeUtilities.s_typeMessage, null, null);
        int index = lvg.getIndex();
        InstructionHandle ihStart = this.m_iList.append((Instruction)new ASTORE(index));
        mg.addLineNumber(ihStart, line);
        this.recursiveAddCleanupCode(mg, this.m_iList, line);
        mg.addLineNumber(this.m_iList.append((Instruction)new ALOAD(index)), line);
        InstructionHandle ihEnd = this.m_iList.append((Instruction)InstructionConstants.ARETURN);
        mg.addLineNumber(ihEnd, line);
        lvg.setStart(ihStart);
        lvg.setEnd(ihEnd);
    }

    protected void recursiveAddCleanupCode(MethodGen mg, InstructionList iList, int line) {
        this.addCleanupCode(mg, iList, line);
        if (this.m_parentFrame != null) {
            this.m_parentFrame.recursiveAddCleanupCode(mg, iList, line);
        }
    }

    protected void addCleanupCode(MethodGen mg, InstructionList iList, int line) {
    }

    public final InstructionHandle appendToInstructionList(InstructionList iList) {
        return iList.append(this.m_iList);
    }

    public void addVariable(String name) {
        this.m_variables.add(name);
    }

    public void addTopVariable(String name) {
        CodeFrame cf = this;
        while (cf.m_parentFrame != null) {
            cf = cf.m_parentFrame;
        }
        cf.m_variables.add(name);
    }

    public String resolveVariableName(String name) {
        if (this.m_variables.contains(name)) {
            return this.resolveLocalVariable(name);
        }
        if (this.m_parentFrame != null) {
            return this.m_parentFrame.resolveVariableName(name);
        }
        if (Interpreter.s_defaultEnvironment.isBound(name)) {
            return this.resolveDefaultEnvironmentVariable(name);
        }
        return null;
    }

    public Set getDefaultEnvironmentVariables() {
        return this.m_defaultEnvironmentVariables;
    }

    public void resolveAllLocalVariables(List names, List resolvedNames) {
        Iterator i = this.m_variables.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String resolvedName = this.resolveLocalVariable(name);
            names.add(name);
            resolvedNames.add(resolvedName);
        }
        i = this.m_childFrames.iterator();
        while (i.hasNext()) {
            ((CodeFrame)i.next()).resolveAllLocalVariables(names, resolvedNames);
        }
    }

    public void resolveAllDefaultEnvironmentVariables(List names, List resolvedNames) {
        Iterator i = this.m_defaultEnvironmentVariables.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String resolvedName = this.resolveDefaultEnvironmentVariable(name);
            names.add(name);
            resolvedNames.add(resolvedName);
        }
    }

    public InstructionHandle generateVariableGet(String name, InstructionList iList, MethodGen mg, int line) {
        if (this.m_variables.contains(name)) {
            String resolvedMemberVariableName = this.resolveLocalVariable(name);
            InstructionHandle ih = iList.append((Instruction)InstructionConstants.THIS);
            mg.addLineNumber(ih, line);
            mg.addLineNumber(iList.append((Instruction)this.m_iFactory.createGetField(this.m_classGen.getClassName(), resolvedMemberVariableName, (Type)Type.OBJECT)), line);
            return ih;
        }
        if (this.m_parentFrame != null) {
            return this.m_parentFrame.generateVariableGet(name, iList, mg, line);
        }
        if (Interpreter.s_defaultEnvironment.isBound(name)) {
            String resolvedMemberVariableName = this.resolveDefaultEnvironmentVariable(name);
            this.m_defaultEnvironmentVariables.add(name);
            InstructionHandle ih = iList.append((Instruction)this.m_iFactory.createGetStatic(this.m_classGen.getClassName(), resolvedMemberVariableName, (Type)Type.OBJECT));
            mg.addLineNumber(ih, line);
            return ih;
        }
        InstructionHandle ih = iList.append((Instruction)InstructionConstants.THIS);
        mg.addLineNumber(ih, line);
        mg.addLineNumber(iList.append((Instruction)this.m_iFactory.createGetField(this.m_classGen.getClassName(), "__dynamicenvironment__", (Type)JavaByteCodeUtilities.s_typeDynamicEnvironment)), line);
        mg.addLineNumber(iList.append((CompoundInstruction)new PUSH(this.m_constantPoolGen, name)), line);
        mg.addLineNumber(iList.append((Instruction)this.m_iFactory.createInvoke(JavaByteCodeUtilities.s_typeDynamicEnvironment.getClassName(), "getValueChecked", (Type)Type.OBJECT, new Type[]{Type.STRING}, (short)182)), line);
        return ih;
    }

    public InstructionHandle generateNewVariablePut(String name, InstructionList iList, MethodGen mg, int line) {
        if (!this.m_variables.contains(name)) {
            this.m_variables.add(name);
        }
        return this.generateLocalVariablePut(name, iList, mg, line);
    }

    public InstructionHandle generateVariablePut(String name, InstructionList iList, MethodGen mg, int line) {
        if (this.m_variables.contains(name)) {
            return this.generateLocalVariablePut(name, iList, mg, line);
        }
        if (this.m_parentFrame != null) {
            return this.m_parentFrame.generateVariablePut(name, iList, mg, line);
        }
        if (Interpreter.s_defaultEnvironment.isBound(name)) {
            String resolvedMemberVariableName = this.resolveDefaultEnvironmentVariable(name);
            this.m_defaultEnvironmentVariables.add(name);
            InstructionHandle ih = iList.append((Instruction)this.m_iFactory.createPutStatic(this.m_classGen.getClassName(), resolvedMemberVariableName, (Type)Type.OBJECT));
            mg.addLineNumber(ih, line);
            return ih;
        }
        this.m_variables.add(name);
        return this.generateLocalVariablePut(name, iList, mg, line);
    }

    protected InstructionHandle generateLocalVariablePut(String name, InstructionList iList, MethodGen mg, int line) {
        String resolvedMemberVariableName = this.resolveLocalVariable(name);
        InstructionHandle ih = iList.append((Instruction)InstructionConstants.THIS);
        mg.addLineNumber(ih, line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.SWAP), line);
        mg.addLineNumber(iList.append((Instruction)this.m_iFactory.createPutField(this.m_classGen.getClassName(), resolvedMemberVariableName, (Type)Type.OBJECT)), line);
        return ih;
    }

    protected String resolveLocalVariable(String name) {
        return "m_" + this.m_frameName + Interpreter.filterSymbols(name);
    }

    protected String resolveDefaultEnvironmentVariable(String name) {
        return "s_" + Interpreter.filterSymbols(name);
    }

    public static void printlnLastObject(InstructionList iList, InstructionFactory iFactory) {
        iList.append((Instruction)InstructionConstants.DUP);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.adenine.compilers.javaByteCode.CodeFrame;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iList.append((Instruction)iFactory.createInvoke(clazz.getName(), "println", (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)184));
    }

    public static void println(Object o) {
        System.err.println(o);
    }
}

