/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compiler;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.compiler.ITemplateExpression;
import edu.mit.lcs.haystack.adenine.compiler.ResourceExpression;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.URIGenerator;
import java.util.ArrayList;
import java.util.Iterator;

public class ExistentialExpression
implements ITemplateExpression {
    ArrayList m_data = new ArrayList();
    Resource m_subject = null;

    public ExistentialExpression() {
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        Iterator i = this.m_data.iterator();
        while (i.hasNext()) {
            Object[] o = (Object[])i.next();
            out.append(o[0]);
            out.append(",");
            out.append(o[1]);
            out.append(" ");
        }
        return "[ee: " + this.m_subject + " " + out + "]";
    }

    public ExistentialExpression(Resource res) {
        this.m_subject = res;
    }

    public void add(ITemplateExpression predicate, ITemplateExpression object) {
        if (predicate == null || object == null) {
            throw new IllegalArgumentException();
        }
        this.m_data.add(new ITemplateExpression[]{predicate, object});
    }

    public void add(Resource predicate, Resource object) {
        if (predicate == null || object == null) {
            throw new IllegalArgumentException();
        }
        this.m_data.add(new ITemplateExpression[]{new ResourceExpression(predicate), new ResourceExpression(object)});
    }

    public void add(Resource predicate, ITemplateExpression object) {
        if (predicate == null || object == null) {
            throw new IllegalArgumentException();
        }
        this.m_data.add(new ITemplateExpression[]{new ResourceExpression(predicate), object});
    }

    public RDFNode generate(URIGenerator urig, IRDFContainer target) throws RDFException, AdenineException {
        Resource res = this.m_subject == null ? urig.generateAnonymousResource() : this.m_subject;
        Iterator i = this.m_data.iterator();
        while (i.hasNext()) {
            ITemplateExpression[] datum = (ITemplateExpression[])i.next();
            target.add(new Statement(res, (Resource)datum[0].generate(urig, target), datum[1].generate(urig, target)));
        }
        return res;
    }

    public ITemplateExpression generateIndirect() {
        ExistentialExpression ee = new ExistentialExpression();
        if (this.m_subject == null) {
            ee.add(Constants.s_rdf_type, AdenineConstants.BNode);
            Iterator i = this.m_data.iterator();
            while (i.hasNext()) {
                ITemplateExpression[] datum = (ITemplateExpression[])i.next();
                ExistentialExpression ee1 = new ExistentialExpression();
                ee1.add(Constants.s_rdf_type, AdenineConstants.Statement);
                ee1.add(AdenineConstants.predicate, datum[0].generateIndirect());
                ee1.add(AdenineConstants.object, datum[1].generateIndirect());
                ee.add(AdenineConstants.statement, (ITemplateExpression)ee1);
            }
        } else {
            ee.add(Constants.s_rdf_type, AdenineConstants.Model);
            ITemplateExpression s = new ResourceExpression(this.m_subject).generateIndirect();
            Iterator i = this.m_data.iterator();
            while (i.hasNext()) {
                ITemplateExpression[] datum = (ITemplateExpression[])i.next();
                ExistentialExpression ee1 = new ExistentialExpression();
                ee1.add(Constants.s_rdf_type, AdenineConstants.Statement);
                ee1.add(AdenineConstants.subject, s);
                ee1.add(AdenineConstants.predicate, datum[0].generateIndirect());
                ee1.add(AdenineConstants.object, datum[1].generateIndirect());
                ee.add(AdenineConstants.statement, (ITemplateExpression)ee1);
            }
        }
        return ee;
    }
}

